/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.wms.vo.stock;

import com.thebeastshop.common.utils.EmptyUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;

public class SkuStatusStock
implements Serializable {
    private String skuCode;
    private Integer skuStatus;
    private Map<String, Integer> suiteQtMap = new HashMap<String, Integer>();

    public int getQuantity() {
        return this.suiteQtMap.values().stream().mapToInt(Integer::intValue).sum();
    }

    public int getQuantity(String suiteCode) {
        return this.suiteQtMap.getOrDefault(this.rebuildSuiteCode(suiteCode), 0);
    }

    public void setQuantity(String suiteCode, int quantity) {
        this.suiteQtMap.put(this.rebuildSuiteCode(suiteCode), quantity);
    }

    public void incrQuantity(String suiteCode, int addQuantity) {
        this.suiteQtMap.put(this.rebuildSuiteCode(suiteCode), this.getQuantity(suiteCode) + addQuantity);
    }

    public void decrQuantity(String suiteCode, int decrQuantity) {
        this.suiteQtMap.put(this.rebuildSuiteCode(suiteCode), this.getQuantity(suiteCode) - decrQuantity);
    }

    public boolean containSuite() {
        return this.suiteQtMap.keySet().stream().anyMatch(key -> EmptyUtil.isNotEmpty((String)key));
    }

    public void forEachSuite(BiConsumer<String, Integer> action) {
        this.suiteQtMap.forEach((suiteCode, suiteQt) -> {
            if (EmptyUtil.isEmpty((String)suiteCode)) {
                return;
            }
            action.accept((String)suiteCode, (Integer)suiteQt);
        });
    }

    private String rebuildSuiteCode(String suiteCode) {
        return suiteCode == null ? "" : suiteCode;
    }

    public String getSkuCode() {
        return this.skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public Integer getSkuStatus() {
        return this.skuStatus;
    }

    public void setSkuStatus(Integer skuStatus) {
        this.skuStatus = skuStatus;
    }

    public SkuStatusStock selfCopy() {
        SkuStatusStock copy = new SkuStatusStock();
        copy.setSkuCode(this.skuCode);
        copy.setSkuStatus(this.skuStatus);
        this.suiteQtMap.forEach((suiteCode, quantity) -> copy.suiteQtMap.put((String)suiteCode, (Integer)quantity));
        return copy;
    }
}

