/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.wms.dataProps;

import com.thebeastshop.wms.dataProps.DataColumn;
import com.thebeastshop.wms.dataProps.RowData;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.SimpleTypeConverter;
import org.springframework.core.ResolvableType;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

@Deprecated
public class PropHelper {
    private static final SimpleTypeConverter simpleTypeConverter = new SimpleTypeConverter();

    public static <T> List<ColItem> extract(T data) {
        if (data == null) {
            return new ArrayList<ColItem>();
        }
        List<ColItem> propColItemList = PropHelper.extract(data, "", "");
        ArrayList<ColItem> flatColItemList = new ArrayList<ColItem>();
        propColItemList.forEach(colItem -> flatColItemList.addAll(PropHelper.getSubColItems(colItem)));
        return flatColItemList;
    }

    public static <T> void merge(T data, List<ColItem> flatColItemList) {
        if (data == null) {
            return;
        }
        List<ColItem> propColItemList = PropHelper.toTree(flatColItemList);
        PropHelper.merge(data, "", propColItemList);
    }

    private static <T> List<ColItem> extract(T data, String parentCode, String parentPath) {
        if (data == null) {
            return new ArrayList<ColItem>();
        }
        ArrayList<ColItem> colItemList = new ArrayList<ColItem>();
        ReflectionUtils.doWithFields(data.getClass(), field -> {
            DataColumn dataColumnAnnotation = field.getAnnotation(DataColumn.class);
            if (dataColumnAnnotation == null) {
                return;
            }
            ReflectionUtils.makeAccessible((Field)field);
            Object fieldValue = ReflectionUtils.getField((Field)field, (Object)data);
            if (fieldValue == null) {
                return;
            }
            String propCode = dataColumnAnnotation.value() != null && !"".equals(dataColumnAnnotation.value()) ? dataColumnAnnotation.value() : field.getName();
            ResolvableType resolvableType = ResolvableType.forField((Field)field);
            Class fieldType = resolvableType.getRawClass();
            if (fieldValue instanceof Iterable) {
                Class elementType = resolvableType.getGeneric(new int[]{0}).getRawClass();
                Iterable collection = (Iterable)fieldValue;
                if (PropHelper.dataAnnotation(elementType)) {
                    ColItem colItem = new ColItem();
                    colItem.configType = PropHelper.buildCode(parentCode, propCode);
                    colItem.configDesc = dataColumnAnnotation.name();
                    colItem.parentCode = parentCode;
                    colItem.configValue = "L[PlaceHolder]";
                    colItem.dataPath = PropHelper.buildPath(parentPath, "");
                    Holder<Integer> indexHolder = new Holder<Integer>(0);
                    ArrayList subColItemList = new ArrayList();
                    collection.forEach(data_i -> {
                        List<ColItem> subItemColItemList = PropHelper.extract(data_i, colItem.configType, String.format("%s[%s]", colItem.dataPath, indexHolder.get()));
                        subColItemList.addAll(subItemColItemList);
                        indexHolder.set((Integer)indexHolder.get() + 1);
                    });
                    colItem.subItemList = subColItemList;
                    if (!subColItemList.isEmpty()) {
                        colItemList.add(colItem);
                    }
                } else {
                    ColItem colItem = new ColItem();
                    colItem.configType = PropHelper.buildCode(parentCode, propCode);
                    colItem.configDesc = dataColumnAnnotation.name();
                    colItem.parentCode = parentCode;
                    colItem.configValue = "L[]";
                    colItem.dataPath = PropHelper.buildCode(parentPath, "");
                    Holder<Integer> indexHolder = new Holder<Integer>(0);
                    ArrayList subColItemList = new ArrayList();
                    collection.forEach(data_i -> {
                        ColItem dataColItem = new ColItem();
                        dataColItem.configType = PropHelper.buildCode(parentCode, propCode);
                        dataColItem.configValue = data_i.toString();
                        dataColItem.parentCode = colItem.configType;
                        dataColItem.dataPath = String.format("%s[%s]", colItem.dataPath, indexHolder.get());
                        indexHolder.set((Integer)indexHolder.get() + 1);
                        subColItemList.add(dataColItem);
                    });
                    colItem.subItemList = subColItemList;
                    if (!subColItemList.isEmpty()) {
                        colItemList.add(colItem);
                    }
                }
            } else if (PropHelper.dataAnnotation(fieldType)) {
                ColItem colItem = new ColItem();
                colItem.configType = PropHelper.buildCode(parentCode, propCode);
                colItem.configDesc = dataColumnAnnotation.name();
                colItem.parentCode = parentCode;
                colItem.subItemList = PropHelper.extract(fieldValue, colItem.configType, parentPath);
                colItem.dataPath = PropHelper.buildCode(parentPath, propCode);
                colItemList.add(colItem);
            } else {
                ColItem dataColItem = new ColItem();
                dataColItem.configType = PropHelper.buildCode(parentCode, propCode);
                dataColItem.configDesc = dataColumnAnnotation.name();
                dataColItem.configValue = fieldValue.toString();
                dataColItem.parentCode = parentCode;
                dataColItem.dataPath = PropHelper.buildCode(parentPath, "");
                colItemList.add(dataColItem);
            }
        });
        return colItemList;
    }

    public static <T> void merge(T data, String parentCode, List<ColItem> colItemList) {
        if (data == null) {
            return;
        }
        Map propColItemMap = colItemList.stream().collect(Collectors.toMap(ColItem::getConfigType, Function.identity(), (i1, i2) -> i1));
        ReflectionUtils.doWithFields(data.getClass(), field -> {
            DataColumn dataColumnAnnotation = field.getAnnotation(DataColumn.class);
            if (dataColumnAnnotation == null) {
                return;
            }
            ReflectionUtils.makeAccessible((Field)field);
            ResolvableType resolvableType = ResolvableType.forField((Field)field);
            Class fieldType = resolvableType.getRawClass();
            String dataPropCode = dataColumnAnnotation.value() != null && !"".equals(dataColumnAnnotation.value()) ? dataColumnAnnotation.value() : field.getName();
            String propCode = PropHelper.buildCode(parentCode, dataPropCode);
            ColItem colItem = (ColItem)propColItemMap.get(propCode);
            if (colItem == null) {
                return;
            }
            if (ClassUtils.isAssignable(Collection.class, (Class)fieldType)) {
                Collection list = PropHelper.instanceCollection(fieldType);
                Class elementType = resolvableType.getGeneric(new int[]{0}).getRawClass();
                if (PropHelper.dataAnnotation(elementType)) {
                    Map<String, List<ColItem>> elementDataMap = colItem.subItemList.stream().collect(Collectors.groupingBy(ColItem::getDataPath));
                    elementDataMap.forEach((path, subItemList) -> {
                        Object elementData = PropHelper.newInstance(elementType);
                        if (elementData != null) {
                            PropHelper.merge(elementData, propCode, subItemList);
                            list.add(elementData);
                        }
                    });
                } else {
                    colItem.subItemList.forEach(subItem -> list.add(PropHelper.convert(((ColItem)subItem).configValue, elementType)));
                }
                ReflectionUtils.setField((Field)field, (Object)data, list);
            } else if (PropHelper.dataAnnotation(fieldType)) {
                Object filedData = PropHelper.newInstance(fieldType);
                PropHelper.merge(filedData, propCode, colItem.subItemList);
                ReflectionUtils.setField((Field)field, (Object)data, filedData);
            } else {
                ReflectionUtils.setField((Field)field, (Object)data, PropHelper.convert(colItem.configValue, fieldType));
            }
        });
    }

    private static List<ColItem> toTree(List<ColItem> colItemList) {
        if (colItemList == null || colItemList.isEmpty()) {
            return new ArrayList<ColItem>();
        }
        Map<String, List<ColItem>> map = colItemList.stream().collect(Collectors.groupingBy(ColItem::getParentCode));
        return PropHelper.buildColSubList("", map);
    }

    private static List<ColItem> buildColSubList(String pCode, Map<String, List<ColItem>> map) {
        ArrayList<ColItem> subColItemlist = new ArrayList<ColItem>();
        List propColItemList = map.getOrDefault(pCode, Collections.emptyList());
        if (propColItemList.isEmpty()) {
            return Collections.emptyList();
        }
        Map<String, List<ColItem>> propColItemDataMap = propColItemList.stream().collect(Collectors.groupingBy(ColItem::getConfigType));
        propColItemDataMap.forEach((propCode, propDataColItemList) -> propDataColItemList.forEach(propDataCol -> {
            List<ColItem> subItemList;
            if (!propCode.equals(pCode) && (subItemList = PropHelper.buildColSubList(propCode, map)) != null && !subItemList.isEmpty()) {
                ((ColItem)propDataCol).subItemList = subItemList;
            }
            subColItemlist.add((ColItem)propDataCol);
        }));
        return subColItemlist;
    }

    private static List<ColItem> getSubColItems(ColItem colItem) {
        ArrayList<ColItem> list = new ArrayList<ColItem>();
        list.add(colItem);
        if (colItem.getSubItemList() != null) {
            colItem.getSubItemList().forEach(colItem1 -> list.addAll(PropHelper.getSubColItems(colItem1)));
            colItem.setSubItemList(null);
        }
        return list;
    }

    private static String buildCode(String pcode, String code) {
        return pcode == null || "".equals(pcode) ? code : pcode + "." + code;
    }

    private static String buildPath(String pPath, String path) {
        return pPath == null || "".equals(pPath) ? path : pPath + "." + path;
    }

    private static <T> T convert(String str, Class<T> clazz) {
        return (T)simpleTypeConverter.convertIfNecessary((Object)str, clazz);
    }

    private static <T> Collection<T> instanceCollection(Class<T> collectType) {
        if (collectType.isAssignableFrom(List.class)) {
            return new ArrayList();
        }
        if (collectType.isAssignableFrom(Set.class)) {
            return new HashSet();
        }
        return null;
    }

    public static <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(ClassUtils.getQualifiedName(clazz) + " newInstance error");
        }
    }

    public static boolean dataAnnotation(Class<?> clazz) {
        RowData annotation = clazz.getAnnotation(RowData.class);
        return annotation != null;
    }

    private static class Holder<T> {
        private T data;

        public Holder(T data) {
            this.data = data;
        }

        public T get() {
            return this.data;
        }

        public void set(T data) {
            this.data = data;
        }
    }

    public static class ColItem
    implements Serializable {
        private String configType;
        private String configDesc;
        private String configValue;
        private String parentCode;
        private String dataPath;
        private List<ColItem> subItemList;

        public String getDataPath() {
            return this.dataPath;
        }

        public void setDataPath(String dataPath) {
            this.dataPath = dataPath;
        }

        public String getConfigType() {
            return this.configType;
        }

        public void setConfigType(String configType) {
            this.configType = configType;
        }

        public String getConfigDesc() {
            return this.configDesc;
        }

        public void setConfigDesc(String configDesc) {
            this.configDesc = configDesc;
        }

        public String getConfigValue() {
            return this.configValue;
        }

        public void setConfigValue(String configValue) {
            this.configValue = configValue;
        }

        public String getParentCode() {
            return this.parentCode;
        }

        public void setParentCode(String parentCode) {
            this.parentCode = parentCode;
        }

        public List<ColItem> getSubItemList() {
            return this.subItemList;
        }

        public void setSubItemList(List<ColItem> subItemList) {
            this.subItemList = subItemList;
        }
    }
}

