/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.wms.constant;

import com.thebeastshop.wms.constant.WMSConstants;

public final class ExpressHelper {
    public static boolean isSf(Integer expressType) {
        return WMSConstants.ExpressType.SF_LAND.equals(expressType) || WMSConstants.ExpressType.SF_AIR.equals(expressType) || WMSConstants.ExpressType.SF_TODAY.equals(expressType) || WMSConstants.ExpressType.SF_COLD_CHAIN.equals(expressType);
    }

    public static boolean isEms(Integer expressType) {
        return WMSConstants.ExpressType.EMS_LAND.equals(expressType) || WMSConstants.ExpressType.EMS_AIR.equals(expressType);
    }

    public static boolean isZt(Integer expressType) {
        return WMSConstants.ExpressType.ZT.equals(expressType);
    }

    public static String buildTiktokLogisticCode(Integer expressType) {
        if (ExpressHelper.isSf(expressType)) {
            return "shunfeng";
        }
        if (ExpressHelper.isZt(expressType)) {
            return "zhongtong";
        }
        if (ExpressHelper.isEms(expressType)) {
            return "ems";
        }
        throw new RuntimeException("\u5feb\u9012\u7c7b\u578b\u4e0d\u652f\u6301");
    }

    public static String buildTiktokLogisticTplUrl(Integer expressType) {
        if (ExpressHelper.isSf(expressType)) {
            return "https://sf3-ttcdn-tos.pstatp.com/obj/logistics-davinci/template/template_sf100.xml";
        }
        if (ExpressHelper.isZt(expressType)) {
            return "https://sf3-ttcdn-tos.pstatp.com/obj/logistics-davinci/template/template_76.xml";
        }
        if (ExpressHelper.isEms(expressType)) {
            return "https://sf3-ttcdn-tos.pstatp.com/obj/logistics-davinci/template/template_ems76.xml";
        }
        throw new RuntimeException("\u5feb\u9012\u7c7b\u578b\u4e0d\u652f\u6301");
    }
}

