/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.watchman.sdk.aop;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.exceptions.ExceptionUtil;
import cn.hutool.core.util.StrUtil;
import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.thebeastshop.kit.prop.PropConfig;
import com.thebeastshop.watchman.sdk.anno.WatchmanJob;
import com.thebeastshop.watchman.sdk.domain.dto.WMJobEndDTO;
import com.thebeastshop.watchman.sdk.domain.dto.WMJobStartDTO;
import com.thebeastshop.watchman.sdk.domain.enums.WMJobEndTypeEnum;
import com.thebeastshop.watchman.sdk.domain.vo.WMJobStartResultVO;
import com.thebeastshop.watchman.sdk.http.client.JobClient;
import com.thebeastshop.watchman.sdk.http.response.Res;
import com.thebeastshop.watchman.sdk.http.response.ResultCode;
import com.thebeastshop.watchman.sdk.utils.WatchmanJobUtils;
import java.lang.reflect.Method;
import java.util.Objects;
import javax.annotation.Resource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

@Aspect
public class WatchmanAop {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Resource
    private JobClient jobClient;
    @Resource
    private Environment environment;

    @Pointcut(value="@annotation(com.thebeastshop.watchman.sdk.anno.WatchmanJob)")
    public void cut() {
    }

    @Around(value="cut()")
    public Object around1(ProceedingJoinPoint jp) throws Throwable {
        MethodSignature signature = (MethodSignature)jp.getSignature();
        Method method = signature.getMethod();
        WatchmanJob watchmanJob = method.getAnnotation(WatchmanJob.class);
        Integer jobId = WatchmanJobUtils.getJobId(this.environment, watchmanJob, method);
        WMJobStartResultVO defaultResult = new WMJobStartResultVO();
        defaultResult.setName(watchmanJob.name());
        defaultResult.setApp(PropConfig.getAppId());
        defaultResult.setJobId(jobId);
        defaultResult.setRecordId(-1L);
        Res<WMJobStartResultVO> res = null;
        try {
            this.log.info(StrUtil.format((CharSequence)"[Watchman] ({})\u73af\u5883\uff1a\u5f00\u59cb\u4efb\u52a1\u76d1\u63a7\u8bb0\u5f55[id = {}]", (Object[])new Object[]{this.environment.getProperty("env", ""), defaultResult.getJobId()}));
            WMJobStartDTO jobStartDTO = new WMJobStartDTO();
            jobStartDTO.setJobId(jobId);
            jobStartDTO.setStartTime(new DateTime().toJdkDate());
            res = this.jobClient.startJob(jobStartDTO);
        }
        catch (Throwable th) {
            this.log.error(StrUtil.format((CharSequence)"[Watchman] \u8bb0\u5f55\u4efb\u52a1[id = {}]\u5f00\u59cb\u4e8b\u4ef6\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f:", (Object[])new Object[]{defaultResult.getJobId()}), th);
        }
        try {
            Object object = jp.proceed();
            if (Objects.isNull(res)) {
                this.log.error(StrUtil.format((CharSequence)"[Watchman] \u8bb0\u5f55\u4efb\u52a1[id = {}]\u6210\u529f\u4e8b\u4ef6\u5f02\u5e38\uff0c\u672a\u5f97\u5230\u5f00\u59cb\u4e8b\u4ef6\u8fd4\u56de\u7ed3\u679c\uff0c\u65e0\u6cd5\u8bb0\u5f55\u6210\u529f\u4e8b\u4ef6", (Object[])new Object[]{jobId}));
                return object;
            }
            if (res.getCode() == ResultCode.SUCCESS.getCode()) {
                WMJobEndDTO jobEndDTO = new WMJobEndDTO();
                jobEndDTO.setRecordId(((WMJobStartResultVO)res.getData()).getRecordId());
                jobEndDTO.setType(WMJobEndTypeEnum.SUCCESS);
                jobEndDTO.setEndTime(new DateTime().toJdkDate());
                this.jobClient.endJob(jobEndDTO);
            } else {
                this.log.error(StrUtil.format((CharSequence)"[Watchman] \u8bb0\u5f55\u4efb\u52a1[id = {}]\u6210\u529f\u4e8b\u4ef6\u5f02\u5e38\uff0c\u54cd\u5e94\u7c7b\u578b: {}\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object[])new Object[]{jobId, res.getCode(), res.getMessage()}));
            }
            return object;
        }
        catch (Throwable e) {
            if (!(e instanceof ForestRuntimeException) && res != null && res.getData() != null) {
                this.log.error(StrUtil.format((CharSequence)"[Watchman] \u4efb\u52a1[id = {}]\u6267\u884c\u65f6\u5f02\u5e38:", (Object[])new Object[]{jobId}), e);
                WMJobEndDTO jobEndDTO = new WMJobEndDTO();
                jobEndDTO.setRecordId(res.getData().getRecordId());
                jobEndDTO.setType(WMJobEndTypeEnum.FAIL);
                jobEndDTO.setMessage(e.getMessage());
                jobEndDTO.setErrorStack(ExceptionUtil.stacktraceToString((Throwable)e));
                jobEndDTO.setEndTime(new DateTime().toJdkDate());
                this.jobClient.endJob(jobEndDTO);
                throw e;
            }
            this.log.error(StrUtil.format((CharSequence)"[Watchman] \u4efb\u52a1[id = {}]\u6267\u884c\u65f6\u5f02\u5e38:", (Object[])new Object[]{jobId}), e);
            throw e;
        }
    }
}

