/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.tx.socket.tio.client;

import com.alibaba.fastjson.JSON;
import com.thebeastshop.tx.socket.client.SocketClient;
import com.thebeastshop.tx.socket.config.ClientConfig;
import com.thebeastshop.tx.socket.tio.SocketPacket;
import com.thebeastshop.tx.socket.tio.client.TioSocketClientAioHandler;
import org.tio.client.ClientChannelContext;
import org.tio.client.ClientGroupContext;
import org.tio.client.ReconnConf;
import org.tio.client.TioClient;
import org.tio.client.intf.ClientAioHandler;
import org.tio.client.intf.ClientAioListener;
import org.tio.core.ChannelContext;
import org.tio.core.Node;
import org.tio.core.Tio;
import org.tio.core.intf.Packet;

public class TioSocketClient
implements SocketClient {
    private ClientChannelContext clientChannelContext;

    public SocketClient initClient(ClientConfig config) {
        TioSocketClientAioHandler tioClientHandler = new TioSocketClientAioHandler();
        tioClientHandler.handler = config.getHandler();
        ClientAioListener aioListener = null;
        ReconnConf reconnConf = new ReconnConf(5000L);
        ClientGroupContext clientGroupContext = new ClientGroupContext((ClientAioHandler)tioClientHandler, aioListener, reconnConf);
        clientGroupContext.setHeartbeatTimeout((long)config.getTimeout());
        try {
            TioClient tioClient = new TioClient(clientGroupContext);
            Node serverNode = new Node(config.getIp(), config.getPort());
            this.clientChannelContext = tioClient.connect(serverNode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    public <T> void send(T t) {
        SocketPacket packet = new SocketPacket();
        packet.setBody(JSON.toJSONString(t).getBytes());
        Tio.send((ChannelContext)this.clientChannelContext, (Packet)packet);
    }
}

