/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.tx.socket.tio;

import com.thebeastshop.tx.socket.tio.SocketPacket;
import java.nio.ByteBuffer;
import org.tio.core.ChannelContext;
import org.tio.core.GroupContext;
import org.tio.core.exception.AioDecodeException;
import org.tio.core.intf.Packet;

public class TioCoder {
    public static ByteBuffer encode(Packet packet, GroupContext groupContext, ChannelContext channelContext) {
        SocketPacket helloPacket = (SocketPacket)packet;
        byte[] body = helloPacket.getBody();
        int bodyLen = 0;
        if (body != null) {
            bodyLen = body.length;
        }
        int allLen = 4 + bodyLen;
        ByteBuffer buffer = ByteBuffer.allocate(allLen);
        buffer.order(groupContext.getByteOrder());
        buffer.putInt(bodyLen);
        if (body != null) {
            buffer.put(body);
        }
        return buffer;
    }

    public static SocketPacket decode(ByteBuffer buffer, int limit, int position, int readableLength, ChannelContext channelContext) throws AioDecodeException {
        if (readableLength < 4) {
            return null;
        }
        int bodyLength = buffer.getInt();
        if (bodyLength < 0) {
            throw new AioDecodeException("bodyLength [" + bodyLength + "] is not right, remote:" + channelContext.getClientNode());
        }
        int neededLength = 4 + bodyLength;
        int isDataEnough = readableLength - neededLength;
        if (isDataEnough < 0) {
            return null;
        }
        SocketPacket imPacket = new SocketPacket();
        byte[] dst = new byte[bodyLength];
        buffer.get(dst);
        imPacket.setBody(dst);
        return imPacket;
    }
}

