/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.tx.socket.netty.client;

import com.alibaba.fastjson.JSON;
import com.thebeastshop.tx.socket.client.SocketClient;
import com.thebeastshop.tx.socket.config.ClientConfig;
import com.thebeastshop.tx.socket.netty.client.ConnectionListener;
import com.thebeastshop.tx.socket.netty.client.NettySocketClientHandler;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.bytes.ByteArrayDecoder;
import io.netty.handler.codec.bytes.ByteArrayEncoder;
import io.netty.util.concurrent.GenericFutureListener;

public class NettySocketClient
implements SocketClient {
    private ClientConfig config;
    private Channel ch;

    public void init(EventLoopGroup eventLoopGroup) {
        try {
            final NettySocketClientHandler nettyClientHandler = new NettySocketClientHandler(this);
            nettyClientHandler.handler = this.config.getHandler();
            Bootstrap b = new Bootstrap();
            ((Bootstrap)((Bootstrap)((Bootstrap)b.group(eventLoopGroup)).channel(NioSocketChannel.class)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) throws Exception {
                    ChannelPipeline p = ch.pipeline();
                    p.addLast(new ChannelHandler[]{new ByteArrayDecoder()});
                    p.addLast(new ChannelHandler[]{new ByteArrayEncoder()});
                    p.addLast(new ChannelHandler[]{nettyClientHandler});
                }
            });
            this.ch = b.connect(this.config.getIp(), this.config.getPort()).addListener((GenericFutureListener)new ConnectionListener(this)).channel();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public SocketClient initClient(ClientConfig config) {
        this.config = config;
        this.init((EventLoopGroup)new NioEventLoopGroup());
        return this;
    }

    public <T> void send(T t) {
        this.ch.writeAndFlush((Object)JSON.toJSONString(t).getBytes());
    }
}

