/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.tx.feign.spring;

import com.thebeastshop.tx.context.MethodDefinationManager;
import com.thebeastshop.tx.hook.CancelInvokeHook;
import java.lang.reflect.Field;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class FeignMethodScanner
implements SmartInitializingSingleton,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(FeignMethodScanner.class);
    private static ApplicationContext applicationContext;

    public void afterSingletonsInstantiated() {
        Map map = applicationContext.getBeansWithAnnotation(FeignClient.class);
        map.forEach((s, o) -> MethodDefinationManager.registerMethod((Class)this.getFeignInterface(o)));
        CancelInvokeHook cancelInvokeHook = (CancelInvokeHook)applicationContext.getBean(CancelInvokeHook.class);
        if (cancelInvokeHook != null) {
            MethodDefinationManager.registerCancelInvokeHook((CancelInvokeHook)cancelInvokeHook);
        }
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        applicationContext = context;
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    private Class getFeignInterface(Object proxy) {
        try {
            Field field = proxy.getClass().getSuperclass().getDeclaredField("h");
            field.setAccessible(true);
            Object h = field.get(proxy);
            field = h.getClass().getDeclaredField("advised");
            field.setAccessible(true);
            AdvisedSupport advised = (AdvisedSupport)field.get(h);
            Class feignClass = advised.getProxiedInterfaces()[0];
            return feignClass;
        }
        catch (Throwable t) {
            log.error("[BEAST-TX]\u83b7\u53d6Feign\u63a5\u53e3\u7c7b\u51fa\u9519", t);
            return null;
        }
    }
}

