package com.thebeastshop.trans.service;

import com.thebeastshop.common.PageQueryResp;
import com.thebeastshop.trans.dto.TsDcOrderDetailQueryDTO;
import com.thebeastshop.trans.dto.TsDcOrderListQueryDTO;
import com.thebeastshop.trans.vo.order.TsOrderStateVO;
import com.thebeastshop.trans.vo.order.ai.TsOrderAiVO;
import com.thebeastshop.trans.vo.order.TsOrderDetailVO;
import com.thebeastshop.trans.vo.order.TsOrderSimpleVO;

import java.util.List;
import java.util.Map;

/**
 * @ClassName: TsDcOrderQueryService
 * @Description: 订单数仓查询
 * @Author xiang.gao
 * @Date 2023/11/22 15:37
 */
public interface TsDcOrderQueryService {

    /**
     * 订单列表查询
     * @param tsDcOrderListQueryDTO
     * @return
     */
    PageQueryResp<TsOrderSimpleVO> queryOrderList(TsDcOrderListQueryDTO tsDcOrderListQueryDTO);

    /**
     * 订单详情查询
     * @param tsDcOrderDetailQueryDTO
     * @return
     */
    TsOrderDetailVO queryOrderDetail(TsDcOrderDetailQueryDTO tsDcOrderDetailQueryDTO);

    /**
     * 查询订单
     * @param memberCode
     * @param orderCode
     * @return
     */
    List<TsOrderAiVO> queryOrderListForAi(String memberCode, String orderCode);

    /**
     * 查询订单状态
     * @param orderCodeList
     * @return
     */
    Map<String, TsOrderStateVO> queryOrderStateList(List<String> orderCodeList);

}
