package com.thebeastshop.trans.enums;

import com.google.common.collect.Lists;

import java.util.List;

/**
 * 订单交易流程状态（前端状态）
 * 
 * @author Paul-xiong
 *
 */
public enum TsTransStatusEnum {

	ALL(1, "全部"),
	PAYING(2, "待支付"),
	WAITING_DELIVER(3, "待发货"),
	DELIVERING(4, "待收货"),
	DONE(5, "已完成"),
	CANCELLED(6, "已取消"),
	PAY_CANCELLED(7, "已取消"),
	PAID(8, "已支付"),
	HOLD_REVIEW(9,"审单挂起"),
	REFUND(10,"申请售后"),

	;

	public static List<TsTransStatusEnum> QUERY_AFTER_SALES = Lists.newArrayList(ALL, DONE, REFUND, DELIVERING);


	private final int id;
	private final String name;

	TsTransStatusEnum(final int id, final String name) {
		this.id = id;
		this.name = name;
	}

	public Integer getId() {
		return id;
	}

	public String getName() {
		return name;
	}

}
