package com.thebeastshop.trans.vo.order.ai;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.thebeastshop.common.BaseDO;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author xiang.gao
 * @date 2025/3/10 19:18
 */
@Data
public class TsOrderAiProductVO implements Serializable {

    @JsonProperty("商品编码")
    private String productCode;

    @JsonProperty("商品名称")
    private String productName;

    @JsonProperty("规格名称")
    private String attributeName;

    @JsonProperty("数量")
    private int quantity;

    @JsonProperty("品类")
    private String category;

    @JsonProperty("是否预售")
    private String isPreSale;

    @JsonProperty("是否赠品")
    private String isGift;

    @JsonProperty("实付金额")
    private BigDecimal actualPayAmount;

    @JsonProperty("退款状态")
    private String refundState;

    @JsonProperty("换货状态")
    private String exchangeState;

    @JsonProperty("换货商品配送信息")
    private String exchangeDeliveryInfo;

    @JsonProperty("换货商品发货快递")
    private String exchangeDeliveryExpress;

    @JsonProperty("是否可申请售后")
    private String canApplyRefund;

    @JsonProperty("不可申请售后原因")
    private String rejectApplyReason;

}
