package com.thebeastshop.trans.enums;

/**
 * 不可申请售后原因枚举
 */
public enum TsReasonAfterSalesEnum {

    CAN_APPLY_REFUND("00", "可申请退换货"),
    PRODUCT_REFUND_APPLYING("01","已有正在进行中的售后申请，查看方式：【我的】-【全部订单】-【售后】-【查看详情】"),
    PRODUCT_REFUND_FINISHED("02","已有处理完成的售后申请，查看方式：【我的】-【全部订单】-【售后】-【查看详情】"),
    CHANNEL_NOT_ONLINE("03","非APP/小程序/野兽派官网购买，建议您联系购买店铺咨询哦！"),
    ORDER_UN_PAY("04", "订单未支付"),
    ORDER_TYPE_SPECIAL("05", "订单类型不支持"),
    ORDER_PAY_TYPE_NOT_SUPPORT("06", "订单支付方式不支持"),
    PACKAGE_STATUS_CANCELED("07", "商品已取消"),
    PACKAGE_STATUS_RECEIVED("08", "包裹签收已超过7天。查看方式：【我的】-【全部订单】-【查看详情】"),
    PACKAGE_STATUS_NOT_DELIVER("09", "订单还未发货，可直接取消订单。查看方式：【我的】-【全部订单】-【查看详情】"),
    PRODUCT_TYPE_SPECIAL("10", "申请商品为特殊商品"),
    ORDER_FUND_PAY_NOT_SUPPORT("11", "订单支付方式不支持"),
    PRODUCT_TYPE_FLOWER("12", "申请商品为鲜花商品"),
    PRODUCT_TYPE_GIFT("13", "申请商品为赠品"),
    PRODUCT_TYPE_FURNITURE("14", "申请商品为大家具"),
    PRODUCT_TYPE_CUSTOMER("15", "申请商品为定制类商品"),
    PRODUCT_TYPE_COMBINATION("16", "申请商品为组合套装类商品"),
    PRODUCT_TYPE_CROSS_BORDER("17", "申请商品为海外购商品")
    ;


    private String code;
    private String desc;

    TsReasonAfterSalesEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public String getAiAnswer() {
        return "经查询，不可自助退换货原因：" + desc;
    }




}
