package com.thebeastshop.trans.enums;


/**
 * 商品包来源。包括用户自主购买的、赠品、加价购
 *
 * @author Liang Wenjian
 */
public enum TsCartPackSourceEnum {

	/**
	 * 来自用户自购
	 */
	RAW(0, "自购"),
	/**
	 * 来自赠品
	 */
	GIFT(3, "买赠"),
	/**
	 * 来自加价购（也是用户自主点击了购买的）
	 */
	CHEAPEN_OTHER(4, "加价购"),
	/**
	 * 权益
	 */
	BENEFIT(5, "权益");

	public final Integer id;
	public final String name;

	TsCartPackSourceEnum(Integer id, String name) {
		this.id = id;
		this.name = name;
	}

	public Integer getId() {
		return id;
	}

	public String getName() {
		return name;
	}
}
