package com.thebeastshop.trans.dto;

import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.trans.enums.TsTransStatusEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @ClassName: TsDcOrderListQueryDTO
 * @Description: 订单列表查询参数
 * @Author xiang.gao
 * @Date 2023/11/22 15:49
 */
@Data
public class TsDcOrderListQueryDTO implements Serializable {

    /**
     * 会员ID
     */
    private Long memberId;

    /**
     * 渠道编码
     */
    private String channelCode;

    /**
     * 订单创建开始时间
     */
    private Date createTimeBegin;

    /**
     * 订单状态
     */
    private TsTransStatusEnum orderStatus;

    /**
     * 访问渠道
     */
    private AccessWayEnum accessWay;

    /**
     * 起始位置
     */
    private int offset;

    /**
     * 查询数量
     */
    private int limit;

    /**
     * 是否查询第三方订单
     */
    private boolean matchThirdOrder;

    /**
     * 搜索商品名
     */
    private String productName;

}
