package com.thebeastshop.trans.vo.refund;

import com.thebeastshop.trans.dto.refund.RefundCreateDTO;
import com.thebeastshop.trans.enums.TsRefundTypeEnum;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 协商历史
 */
public class RefundTrackVO implements Serializable {

    private static final long serialVersionUID = 8024107512770135449L;

    /**
     * 发生日期
     */
    private String date;

    /**
     * 标题
     */
    private String title;


    /**
     * 退货售后单
     */
   private ReturnDelivery returnDelivery;

    /**
     * 售后申请信息
     */
   private RefundApplyInfo refundApplyInfo;

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public ReturnDelivery getReturnDelivery() {
        return returnDelivery;
    }

    public void setReturnDelivery(ReturnDelivery returnDelivery) {
        this.returnDelivery = returnDelivery;
    }

    public RefundApplyInfo getRefundApplyInfo() {
        return refundApplyInfo;
    }

    public void setRefundApplyInfo(RefundApplyInfo refundApplyInfo) {
        this.refundApplyInfo = refundApplyInfo;
    }

    public String getDate() {
        return date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    /**
     * 退货物流信息
     */
    public static class ReturnDelivery implements Serializable {
        private static final long serialVersionUID = -4873701287413981795L;
        /**
         * 退货物流单号
         */
        private String deliveryNo;


        /**
         * 退货快递公司名称
         */
        private String expressName;

        public String getDeliveryNo() {
            return deliveryNo;
        }

        public void setDeliveryNo(String deliveryNo) {
            this.deliveryNo = deliveryNo;
        }

        public String getExpressName() {
            return expressName;
        }

        public void setExpressName(String expressName) {
            this.expressName = expressName;
        }
    }


    /**
     * 售后的申请信息
     */
    public static class RefundApplyInfo implements Serializable {
        private static final long serialVersionUID = -4873701287413981795L;
        /**
         * 退货物流单号
         */
        private TsRefundTypeEnum refundType;

        /**
         * 售后理由
         */
        private String refundReason;

        /**
         * 退货商品数量
         */
        private Integer returnNum;

        /**
         * 退款金额
         */
        private BigDecimal refundAmt;

        /**
         * 售后详情
         */
        private String refundDesc;

        /**
         * 售后媒体文件
         */
        private List<RefundCreateDTO.RefundMedia> refundMedias;

        public TsRefundTypeEnum getRefundType() {
            return refundType;
        }

        public void setRefundType(TsRefundTypeEnum refundType) {
            this.refundType = refundType;
        }

        public String getRefundReason() {
            return refundReason;
        }

        public void setRefundReason(String refundReason) {
            this.refundReason = refundReason;
        }

        public Integer getReturnNum() {
            return returnNum;
        }

        public void setReturnNum(Integer returnNum) {
            this.returnNum = returnNum;
        }

        public BigDecimal getRefundAmt() {
            return refundAmt;
        }

        public void setRefundAmt(BigDecimal refundAmt) {
            this.refundAmt = refundAmt;
        }

        public List<RefundCreateDTO.RefundMedia> getRefundMedias() {
            return refundMedias;
        }

        public void setRefundMedias(List<RefundCreateDTO.RefundMedia> refundMedias) {
            this.refundMedias = refundMedias;
        }

        public String getRefundDesc() {
            return refundDesc;
        }

        public void setRefundDesc(String refundDesc) {
            this.refundDesc = refundDesc;
        }
    }

}
