package com.thebeastshop.trans.enums;

/**
 * 不可修改地址原因枚举
 */
public enum TsReasonAddressEnum {

    CAN_MODIFY_ADDRESS("00", "可修改地址"),
    ORDER_ADDRESS_MODIFIED("01", "订单已修改过地址，订单付款后仅支持修改一次。"),
    CHANNEL_NOT_ONLINE("02","非APP/小程序/野兽派官网购买。建议您联系购买店铺咨询哦！"),
    ORDER_TYPE_SPECIAL("03", "订单类型不支持"),
    ORDER_STATUS_NOT_SUPPORT("04", "订单已取消或已发货"),
    PACKAGE_PRODUCT_SEND("05", "部分商品已进入发货流程"),
    PACKAGE_DIFF_ADDRESS("06", "订单中存在多个包裹不同地址的情况"),
    PACKAGE_STORE_SEND("07", "订单部分商品已进入发货流程"),
    PRODUCT_TYPE_SPECIAL("08", "订单中含有定制类/大家具商品"),
    PRODUCT_TYPE_FLOWER("09", "订单中含有鲜花商品");

    private String code;
    private String desc;

    TsReasonAddressEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public String getAiAnswer() {
        return "经查询，不可修改地址原因：" + desc;
    }


}
