package com.thebeastshop.trans.service;

import com.thebeastshop.common.PageQueryResp;
import com.thebeastshop.trans.dto.TsOrderDetailQueryDTO;
import com.thebeastshop.trans.dto.TsOrderListQueryDTO;
import com.thebeastshop.trans.enums.TsLogisticsTypeEnum;
import com.thebeastshop.trans.vo.logistics.TsLogisticsDetailVO;
import com.thebeastshop.trans.vo.order.TsOrderDetailVO;
import com.thebeastshop.trans.vo.order.TsOrderSimpleVO;

/**
 * <p>Title: thebeastshop</p>
 * <p>Copyright: Copyright (c) 2016</p>
 * @author Bryan Zhang
 * @date 2017-1-17
 * @description 订单查询服务
 */
public interface TsOrderQueryService {
	
	/**
	 * 订单列表查询
	 */
	PageQueryResp<TsOrderSimpleVO> queryOrderList(TsOrderListQueryDTO dto);

	/**
	 * 订单详情查询 同时使用orderCode和memberId查询
	 */
	TsOrderDetailVO queryOrderDetail(TsOrderDetailQueryDTO dto);

	/**
	 * 订单详情查询 仅使用orderCode查询
	 */
	TsOrderDetailVO queryOrderDetailWithoutMemberId(TsOrderDetailQueryDTO dto);

	/**
	 * 物流详情
	 */
	TsLogisticsDetailVO getLogisticsDetail(String logisticCode, TsLogisticsTypeEnum type);
	
	TsLogisticsDetailVO getLogisticsDetail(TsLogisticsTypeEnum type,Long packageId);

	/**
	 * 
	 * @param memberCode
	 * @param channelCode
	 * @return
	 */
	boolean ifFirstOrder(String memberCode, String channelCode);

}
