package com.thebeastshop.trans.enums;

/**
 * 订单示例枚举
 * 包含 不可取消、不可修改地址、不可申请退换货
 */
public enum TsOrderCaseEnum {
    CAN_CANCEL_ORDER( "可取消订单"),
    CAN_MODIFY_ADDRESS( "可修改地址"),
    CAN_APPLY_REFUND( "可申请退换货"),
    CHANNEL_NOT_ONLINE("非本渠道购买"),
    ORDER_CANCELLED( "当前订单已取消"),
    ORDER_TYPE_SPECIAL( "订单类型不支持"),
    ORDER_STATUS_NOT_SUPPORT( "订单状态存在已取消/已发货的情况"),
    ORDER_EMPLOYEE_GIFT_CARD( "订单中包含员工礼品卡商品"),
    ORDER_STORE_SEND( "订单中包含门店发货商品"),
    PACKAGE_STATUS_SEND( "部分商品已进入发货流程"),
    PACKAGE_STATUS_RECEIVED( "包裹存在签收已超过7天/还未发货的情况"),
    PACKAGE_DIFFERENT_ADDRESS( "订单中包含不同地址商品"),
    PACKAGE_USED_FUND("订单支付类型不支持"),
    PRODUCT_IS_GIFT("申请商品为赠品"),
    PRODUCT_TYPE_SPECIAL( "订单中含有定制类/大家具商品"),
    PRODUCT_TYPE_SPECIAL_REFUND("订单中含有定制类或其他特殊商品"),
    PRODUCT_TYPE_FLOW("订单中包含花型商品"),
    PRODUCT_CANCELLED("订单中存在部分商品已取消的情况"),
    PRODUCT_REFUND_APPLYING("有正在进行中的退款单/换货单"),
    ORDER_ADDRESS_MODIFIED("单已修改过地址");

    private String desc;

    TsOrderCaseEnum(String desc) {
        this.desc = desc;
    }
    public String getDesc() {
        return desc;
    }
    public String getAiAnswer(String applyType) {
        return String.format("您好，您咨询的订单不可%s订单原因为【%s】", applyType, desc);
    }




}
