package com.thebeastshop.trans.vo.order.ai;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * AI订单信息
 * @author xiang.gao
 * @date 2025/3/10 13:26
 */
@Data
public class TsOrderAiVO implements Serializable {

    @JsonProperty("订单号")
    private String orderCode;

    @JsonProperty("渠道")
    private String channelName;

    @JsonProperty("下单时间")
    private String payTime;

    @JsonProperty("支付方式")
    private String payTypeDesc;

    @JsonProperty("支付金额")
    private BigDecimal price;

    @JsonProperty("是否可取消")
    private String canCancel;

    @JsonProperty("不可取消原因")
    private String uncancelledReason;

    @JsonProperty("是否能改地址")
    private String editAddress;

    @JsonProperty("不可修改地址原因")
    private String editAddressDesc;

    @JsonProperty("是否匿名订单")
    private String anonymous;

    @JsonProperty("订单取消原因")
    private String cancelReason;

    @JsonProperty("渠道说明")
    private String channelDesc;

    @JsonProperty("包裹信息")
    private List<TsOrderAiPackageVO> packages;

}
