package com.thebeastshop.trans.vo.order.ai;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.thebeastshop.common.BaseDO;

import java.math.BigDecimal;
import java.util.List;

/**
 * AI订单信息
 * @author xiang.gao
 * @date 2025/3/10 13:26
 */
public class TsOrderAiVO extends BaseDO {

    @JsonProperty("订单号")
    private String orderCode;

    @JsonProperty("渠道")
    private String channelName;

    @JsonProperty("下单时间")
    private String payTime;

    @JsonProperty("支付方式")
    private String payTypeDesc;

    @JsonProperty("支付金额")
    private BigDecimal price;

    @JsonProperty("是否可取消")
    private String cancelable;

    @JsonProperty("是否可编辑地址")
    private String editAddress;

    @JsonProperty("包裹信息")
    private List<TsOrderAiPackageVO> packages;

    public String getOrderCode() {
        return orderCode;
    }

    public void setOrderCode(String orderCode) {
        this.orderCode = orderCode;
    }

    public String getChannelName() {
        return channelName;
    }

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    public String getPayTime() {
        return payTime;
    }

    public void setPayTime(String payTime) {
        this.payTime = payTime;
    }

    public String getPayTypeDesc() {
        return payTypeDesc;
    }

    public void setPayTypeDesc(String payTypeDesc) {
        this.payTypeDesc = payTypeDesc;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public String getCancelable() {
        return cancelable;
    }

    public void setCancelable(String cancelable) {
        this.cancelable = cancelable;
    }

    public String getEditAddress() {
        return editAddress;
    }

    public void setEditAddress(String editAddress) {
        this.editAddress = editAddress;
    }

    public List<TsOrderAiPackageVO> getPackages() {
        return packages;
    }

    public void setPackages(List<TsOrderAiPackageVO> packages) {
        this.packages = packages;
    }

}
