package com.thebeastshop.trans.enums;

import com.google.common.collect.Lists;

import java.util.Collections;
import java.util.List;

/**
 * 包裹状态
 */
public enum TsOrderPackageStatusEnum {

	UNKNOW(0, "未知状态"),
	UNSENT_CANCEL(-1, "未发货取消"),
    INIT(10, "初始状态"),
    INITIAL_HANG(1, "初始挂起"),
    MAKING_HANG(2, "制单挂起"),
    WAITING_MAKE(11, "待制单"),
    WAITING_SEND(12, "待发货"),
    WAITING_RECEIVE(13, "待收货"),
    ALREADY_RECEIVE(14, "已收货"),
    ALREADY_DELIVER(15, "已发货"),
	;
	
	private Integer code;
	
	private String name;

	TsOrderPackageStatusEnum(Integer code, String name) {
		this.code = code;
		this.name = name;
	}

	public Integer getCode() {
		return code;
	}
	
	public String getName(){
		return name;
	}

	/**
	 * 配送中状态组
	 */
	public static final List<TsOrderPackageStatusEnum> DELIVERING_ARRAYS = Collections.unmodifiableList(Lists.newArrayList(WAITING_RECEIVE, ALREADY_RECEIVE, ALREADY_DELIVER));

	public static TsOrderPackageStatusEnum getEnumByCode(Integer code) {
		for (TsOrderPackageStatusEnum e : TsOrderPackageStatusEnum.values()) {
			if (e.getCode().equals(code)) {
				return e;
			}
		}
		return UNKNOW;
	}
	
	@Override
	public String toString() {
		return this.getCode().toString();
	}
}
