package com.thebeastshop.trans.vo.order;


import java.util.Collection;

import com.thebeastshop.common.BaseDO;
import com.thebeastshop.trans.vo.logistics.TsLogisticsBasicVO;
import com.thebeastshop.trans.vo.logistics.TsLogisticsDetailVO;
import com.thebeastshop.trans.vo.member.TsMemberAddressVO;

/**
 * 订单包裹
 *
 * @author Paul-xiong
 *
 */
public class TsOrderParcelVO extends BaseDO {

	/**
	 * 包裹Id
	 */
	private Long id;

	/**
	 * 包裹号
	 */
	private String code;

	/**
	 * 收获信息
	 */
	private TsMemberAddressVO address;

	/**
	 * 物流信息
	 */
	private TsLogisticsBasicVO logistics;

	/**
	 * 商品包
	 */
	private Collection<TsOrderProductPackVO> packs;

	/**
	 * 包裹状态
	 */
	private TsOrderParcelStateVO state;

	/**
	 * 包裹类型
	 */
	private TsOrderParcelTypeVO parcelType;
	/**
	 * 配送日期
	 */
	private String sendDate;
	/**
	 * 收货日期
	 */
	private String receiveDate;

	/**
	 * 限时送达时段
	 */
	private String limitDeliveryTime;

	/**
	 * 包裹的物流轨迹
	 */
	private TsLogisticsDetailVO tsLogisticsDetailVO;

	public TsOrderParcelVO() {
		super();
	}

	public TsMemberAddressVO getAddress() {
		return address;
	}

	public void setAddress(TsMemberAddressVO address) {
		this.address = address;
	}

	public TsLogisticsBasicVO getLogistics() {
		return logistics;
	}

	public void setLogistics(TsLogisticsBasicVO logistics) {
		this.logistics = logistics;
	}

	public Collection<TsOrderProductPackVO> getPacks() {
		return packs;
	}

	public void setPacks(Collection<TsOrderProductPackVO> packs) {
		this.packs = packs;
	}

	public TsOrderParcelStateVO getState() {
		return state;
	}

	public void setState(TsOrderParcelStateVO state) {
		this.state = state;
	}

	public String getSendDate() {
		return sendDate;
	}

	public void setSendDate(String sendDate) {
		this.sendDate = sendDate;
	}

	public String getReceiveDate() {
		return receiveDate;
	}

	public void setReceiveDate(String receiveDate) {
		this.receiveDate = receiveDate;
	}

	public String getLimitDeliveryTime() {
		return limitDeliveryTime;
	}

	public void setLimitDeliveryTime(String limitDeliveryTime) {
		this.limitDeliveryTime = limitDeliveryTime;
	}

	public TsLogisticsDetailVO getTsLogisticsDetailVO() {
		return tsLogisticsDetailVO;
	}

	public void setTsLogisticsDetailVO(TsLogisticsDetailVO tsLogisticsDetailVO) {
		this.tsLogisticsDetailVO = tsLogisticsDetailVO;
	}

	public TsOrderParcelTypeVO getParcelType() {
		return parcelType;
	}

	public void setParcelType(TsOrderParcelTypeVO parcelType) {
		this.parcelType = parcelType;
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	@Override
	public String toString() {
		return "TsOrderParcelVO [logistics=" + logistics + ", packs=" + packs + ", state=" + state + "]";
	}

}
