/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.trans.vo.order;

import com.thebeastshop.common.BaseDO;

/**
 * 订单卡片
 */
public class OrderCardVO extends BaseDO {

	/**
	 * 文案
	 */
	private String title;

	/**
	 * 卡片类型，0不需要1空白2代写
	 */
	private String type;

	/**
	 * 卡片抬头信息
	 */
	private String to;
	/**
	 * 卡片正文
	 */
	private String content;

	/**
	 * 卡片落款信息
	 */
	private String from;

	/**
	 * 日期（一个普通展示字段，无业务意义）
	 */
	private String date;

	/**
	 * 标签（一个普通展示字段，无业务意义）
	 */
	private String label;

	/**
	 * 跳转链接
	 */
	private String viewLink;

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public String getTo() {
		return to;
	}

	public void setTo(String to) {
		this.to = to;
	}

	public String getContent() {
		return content;
	}

	public void setContent(String content) {
		this.content = content;
	}

	public String getFrom() {
		return from;
	}

	public void setFrom(String from) {
		this.from = from;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getDate() {
		return date;
	}

	public void setDate(String date) {
		this.date = date;
	}

	public String getLabel() {
		return label;
	}

	public void setLabel(String label) {
		this.label = label;
	}

	public String getViewLink() {
		return viewLink;
	}

	public void setViewLink(String viewLink) {
		this.viewLink = viewLink;
	}

	@Override
	public String toString() {
		return "OrderCardVO{" +
				"title='" + title + '\'' +
				", type='" + type + '\'' +
				", to='" + to + '\'' +
				", content='" + content + '\'' +
				", from='" + from + '\'' +
				", date='" + date + '\'' +
				", label='" + label + '\'' +
				'}';
	}
}