package com.thebeastshop.trans.enums;

/**
 * t_op_so_package表 PACKAGE_STATUS字段
 * @author donghui
 */
public enum TsSoPackageTypeEnum {
	PACKAGE_TYPE_0(0, "普通包"),
	PACKAGE_TYPE_1(1, "海淘 包"),
	PACKAGE_TYPE_2(2, "预售包"),
	PACKAGE_TYPE_3(3, "鲜花 包"),
	PACKAGE_TYPE_4(4, "代销包"),
	PACKAGE_TYPE_5(5, "定制包"),
	PACKAGE_TYPE_6(6, "来单制作包"),
	PACKAGE_TYPE_7(7, "大家具包"),
	PACKAGE_TYPE_8(8, "虚拟商品包");
    
    public Integer code;
    public String cn;
	TsSoPackageTypeEnum(Integer code, String cn) {
		this.code = code;
		this.cn = cn;
	}


	public static TsSoPackageTypeEnum getEnumByCode(Integer code) {
		if (code != null) {
			for (TsSoPackageTypeEnum e : TsSoPackageTypeEnum.values()) {
				if (e.code == code) {
					return e;
				}
			}
		}
		return null;
	}


	public Integer getCode() {
		return code;
	}


	public void setCode(Integer code) {
		this.code = code;
	}


	public String getCn() {
		return cn;
	}


	public void setCn(String cn) {
		this.cn = cn;
	}
	
	
}
