package com.thebeastshop.trans.vo.product;


import com.thebeastshop.common.BaseDO;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;

/**
 * 
 * @author Paul-xiong
 *
 */
public class TsSpvVO extends BaseDO {

	/**
	 * spvId
	 */
	private Long id;

	/**
	 * 名称
	 */
	private String name;

	/**
	 * 剩余库存量
	 */
	private Integer left;

	/**
	 * 默认图片
	 */
	private String image;

	/**
	 * 品牌
	 */
	private TsBrandVO brand;

	/**
	 * 最小购买数量，默认为 1
	 */
	private int minAmount = 1;

	/**
	 * 原价
	 */
	private BigDecimal rawPrice;

	/**
	 * 折扣价
	 */
	private BigDecimal price;

	/**
	 * 规格维度的选项组合
	 */
	private Collection<Integer> group;

	/**
	 * 一句话推荐
	 */
	private String summary;

	/**
	 * 描述
	 */
	private String spvDesc;

	/**
	 * skuCodes（XXX:临时需要,以后可能会移除）
	 */
	private List<String> skuCodes;

	/**
	 * 商品 code（XXX:临时需要,以后可能会移除）
	 */
	private String productCode;

	/**
	 * APP专享价
	 */
	private TsDiscVO discount;

	/**
	 * 抢购
	 */
	private TsFlashSaleVO flashSale;

	/**
	 * 是否为预售商品，若不是预售，则为 null
	 */
	private TsPreSellVO presell;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Integer getLeft() {
		return left;
	}

	public void setLeft(Integer left) {
		this.left = left;
	}

	public String getImage() {
		return image;
	}

	public void setImage(String image) {
		this.image = image;
	}

	public String getSpvDesc() {
		return spvDesc;
	}

	public void setSpvDesc(String spvDesc) {
		this.spvDesc = spvDesc;
	}

	public TsBrandVO getBrand() {
		return brand;
	}

	public void setBrand(TsBrandVO brand) {
		this.brand = brand;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public BigDecimal getRawPrice() {
		return rawPrice;
	}

	public void setRawPrice(BigDecimal rawPrice) {
		this.rawPrice = rawPrice;
	}

	public BigDecimal getPrice() {
		return price;
	}

	public void setPrice(BigDecimal price) {
		this.price = price;
	}

	public List<String> getSkuCodes() {
		return skuCodes;
	}

	public void setSkuCodes(List<String> skuCodes) {
		this.skuCodes = skuCodes;
	}

	public String getProductCode() {
		return productCode;
	}

	public void setProductCode(String productCode) {
		this.productCode = productCode;
	}

	public String getSummary() {
		return summary;
	}

	public void setSummary(String summary) {
		this.summary = summary;
	}

	public int getMinAmount() {
		return minAmount;
	}

	public void setMinAmount(int minAmount) {
		this.minAmount = minAmount;
	}

	public Collection<Integer> getGroup() {
		return group;
	}

	public void setGroup(Collection<Integer> group) {
		this.group = group;
	}

	public TsPreSellVO getPresell() {
		return presell;
	}

	public void setPresell(TsPreSellVO presell) {
		this.presell = presell;
	}

	public TsFlashSaleVO getFlashSale() {
		return flashSale;
	}

	public void setFlashSale(TsFlashSaleVO flashSale) {
		this.flashSale = flashSale;
	}

	public TsDiscVO getDiscount() {
		return discount;
	}

	public void setDiscount(TsDiscVO discount) {
		this.discount = discount;
	}

	@Override
	public String toString() {
		return "TsSpvVO{" +
				"id=" + id +
				", name='" + name + '\'' +
				", left=" + left +
				", image='" + image + '\'' +
				", brand=" + brand +
				", minAmount=" + minAmount +
				", rawPrice=" + rawPrice +
				", price=" + price +
				", group=" + group +
				", summary='" + summary + '\'' +
				", spvDesc='" + spvDesc + '\'' +
				", skuCodes=" + skuCodes +
				", productCode='" + productCode + '\'' +
				", discount=" + discount +
				", flashSale=" + flashSale +
				", presell=" + presell +
				'}';
	}
}
