package com.thebeastshop.trans.service;

import com.thebeastshop.common.PageQueryResp;
import com.thebeastshop.trans.dto.TsDcOrderDetailQueryDTO;
import com.thebeastshop.trans.dto.TsDcOrderListQueryDTO;
import com.thebeastshop.trans.dto.TsOrderDetailQueryDTO;
import com.thebeastshop.trans.vo.order.TsOrderDetailVO;
import com.thebeastshop.trans.vo.order.TsOrderSimpleVO;

/**
 * @ClassName: TsDcOrderQueryService
 * @Description: 订单数仓查询
 * @Author xiang.gao
 * @Date 2023/11/22 15:37
 */
public interface TsDcOrderQueryService {

    /**
     * 订单列表查询
     * @param tsDcOrderListQueryDTO
     * @return
     */
    PageQueryResp<TsOrderSimpleVO> queryOrderList(TsDcOrderListQueryDTO tsDcOrderListQueryDTO);

    /**
     * 订单详情查询
     * @param tsDcOrderDetailQueryDTO
     * @return
     */
    TsOrderDetailVO queryOrderDetail(TsDcOrderDetailQueryDTO tsDcOrderDetailQueryDTO);


}
