package com.thebeastshop.trans.enums;

/**
 * t_op_sales_order表SALES_ORDER_STATUS字段 订单状态
 * @author donghui
 */
public enum TsSalesOrderStatusEnum {
    CANCLE(0,"取消"),
    NONPAYMENT(1,"未付款"),
    HOLD(2,"未付款挂起"),
    NOAUDIT(3,"待审批"),
    CHANGE_AFTER_RECEIVE(5,"换货待收货"),
    HOLD_REVIEW(9,"审单挂起"),
    WAITING_REVIEW(10,"待审单"),
    ALREADY_REVIEW(11,"已审单"),
    ALREADY_FINISHED(12, "已完成");
	
	public Integer code;
	public String cn;

	TsSalesOrderStatusEnum(Integer code, String cn) {
		this.code = code;
		this.cn = cn;
	}

	public static TsSalesOrderStatusEnum getEnumByCode(Integer code) {
		for (TsSalesOrderStatusEnum e : TsSalesOrderStatusEnum.values()) {
			if (e.code == code) {
				return e;
			}
		}
		return null;
	}
}
