/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.trans.exception;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TsBaseException
extends RuntimeException {
    private static final long serialVersionUID = 4904242843495439482L;
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String id = this.buildId();

    public TsBaseException(String message) {
        super(message);
    }

    private String buildId() {
        Thread thread = Thread.currentThread();
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            return thread.getId() + "_" + System.currentTimeMillis() + '_' + inetAddress.getHostAddress();
        }
        catch (UnknownHostException e) {
            this.logger.warn("\u4e0d\u5e94\u8be5\u53d1\u751f", (Throwable)e);
            return thread.getId() + "_" + System.currentTimeMillis();
        }
    }

    public String getId() {
        return this.id;
    }
}

