package com.thebeastshop.trans.enums;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;

/**
 * 订单流程状态(后端订单状态)。
 *
 * @author Liang Wenjian
 */
public enum TsOrderFlowStatusEnum {

	CANCELLED(0, "已取消"),
	CONFIRMED(1, "未付款"),
	CUSTOMER_HUNG_UP(2, "未付款挂起"),
	CREATED(3, "待审批") ,
	CHANGE_AFTER_RECEIVE(5, "换货待收货完成"),
	AUDIT_HUNG_UP(9, "审单挂起"),
	PAID(10, "待审单"),
	AUDITED(11, "已审单"),
	DONE(12, "已完成") ;

	/**
	 * 已确认的订单状态组
	 */
	public static final List<TsOrderFlowStatusEnum> IS_CONFIRMED_ARRAYS = Collections.unmodifiableList(Lists.newArrayList(CONFIRMED, CUSTOMER_HUNG_UP));

	public static boolean isConfirmed(int id) {
		for (TsOrderFlowStatusEnum state : IS_CONFIRMED_ARRAYS) {
			if (state.getId().intValue() == id)
				return true;
		}
		return false;
	}



	public final int id;
	public final String name;

	TsOrderFlowStatusEnum(final int id, final String name) {
		this.id = id;
		this.name = name;
	}

	public Integer getId() {
		return id;
	}

	public String getName() {
		return name;
	}

	public static TsOrderFlowStatusEnum getEnumById(Integer id) {
		for (TsOrderFlowStatusEnum e : TsOrderFlowStatusEnum.values()) {
			if (e.getId().equals(id)) {
				return e;
			}
		}
		return null;
	}

}
