package com.thebeastshop.trans.enums;

/**
 * @ClassName: SoIdCardFailEnum
 * @Description: 文件描述...
 * @author: Xiang.Gao
 * @date: 2020/11/25 16:06
 */
public enum TsOrderIdCardFailEnum {

    INCONFORMITY(1, "用户不符"),
    PICTURE_BLUR(2, "图片不清晰"),
    NAME_COVER(2, "姓名被遮挡"),
    IDNUM_COVER(4, "身份证号被遮挡"),
    UNKNOWN(5, "原因不详");

    private Integer code;

    private String desc;

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    TsOrderIdCardFailEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static TsOrderIdCardFailEnum getByCode(Integer code) {
        for (TsOrderIdCardFailEnum failEnum : TsOrderIdCardFailEnum.values()) {
            if (failEnum.code.equals(code)) {
                return failEnum;
            }
        }
        return TsOrderIdCardFailEnum.UNKNOWN;
    }



}
