package com.thebeastshop.trans.enums;

/**
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2017-03-03 17:13
 */
public enum TsWeekEnum {

	SUNDAY(1,"周日"),
    MONDAY(2,"周一"),
    TUESDAY(3,"周二"),
    WEDNESDAY(4,"周三"),
    THURSDAY(5,"周四"),
    FRIDAY(6,"周五"),
    SATURDAY(7,"周六");

    private Integer id;
    private String name;

    TsWeekEnum(final int id, final String name) {
        this.id = id;
        this.name = name;
    }

    public Integer getId() {
        return id;
    }

    public String getName() {
        return name;
    }
    
    public static TsWeekEnum getEnumByCode(Integer id) {
		for (TsWeekEnum e : TsWeekEnum.values()) {
			if (e.getId().equals(id)) {
				return e;
			}
		}
		return null;
	}

}
