package com.thebeastshop.trans.vo.order;


import com.thebeastshop.common.BaseDO;
import com.thebeastshop.trans.enums.TsRefundStepEnum;
import com.thebeastshop.trans.vo.TsLabelVO;
import com.thebeastshop.trans.vo.product.TsSpvVO;
import com.thebeastshop.trans.vo.refund.RefundInfoVO;

import java.util.Collection;
import java.util.Collections;
import java.util.List;

/**
 * 订单商品包
 *
 * @author Paul-xiong
 */
public class TsOrderProductPackVO extends BaseDO {
    private static final long serialVersionUID = -7183963461949440462L;
    /**
     *
     */
    private Long id;
    /**
     * 数量
     */
    private int count;
    /**
     * 商品编号
     */
    private String productId;
    /**
     * spv信息
     */
    private TsSpvVO spv;
    /**
     * 标签
     */
    private Collection<TsLabelVO> labels;
    /**
     * 商品标签
     */
    private String lable;

    /**
     * 该商品行的所有的售后单信息
     * 订单列表和订单详情具体返回的字段不同，
     * 订单列表只返回状态
     */
    private  List<RefundInfoVO> refundInfos = Collections.emptyList();
    /**
     * 定制卡片
     */
    private OrderCustomCardVO customCard;

    /**
     * 是否礼品
     */
    private Boolean isGift = Boolean.FALSE;


    /**
     * 该商品行是否可申请售后
     */
    private Boolean canApplyRefund = Boolean.FALSE;

    /**
     * 售后申请状态，如有售后单则有值，APPLY 退款中，SUCCESS 退款成功，CLOSE 退款关闭。
     */
    private TsRefundStepEnum.RefundSimpleStatusType refundState;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public int getCount() {
        return count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public TsSpvVO getSpv() {
        return spv;
    }

    public void setSpv(TsSpvVO spv) {
        this.spv = spv;
    }

    public Collection<TsLabelVO> getLabels() {
        return labels;
    }

    public void setLabels(Collection<TsLabelVO> labels) {
        this.labels = labels;
    }

    public String getProductId() {
        return productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public String getLable() {
        return lable;
    }

    public void setLable(String lable) {
        this.lable = lable;
    }

    public OrderCustomCardVO getCustomCard() {
        return customCard;
    }

    public void setCustomCard(OrderCustomCardVO customCard) {
        this.customCard = customCard;
    }

    public Boolean getGift() {
        return isGift;
    }

    public void setGift(Boolean gift) {
        isGift = gift;
    }

    public List<RefundInfoVO> getRefundInfos() {
        return refundInfos;
    }

    public void setRefundInfos(List<RefundInfoVO> refundInfos) {
        this.refundInfos = refundInfos;
    }

    public Boolean getCanApplyRefund() {
        return canApplyRefund;
    }

    public void setCanApplyRefund(Boolean canApplyRefund) {
        this.canApplyRefund = canApplyRefund;
    }

    public TsRefundStepEnum.RefundSimpleStatusType getRefundState() {
        return refundState;
    }

    public void setRefundState(TsRefundStepEnum.RefundSimpleStatusType refundState) {
        this.refundState = refundState;
    }

    @Override
    public String toString() {
        return "TsOrderProductPackVO{" +
                "id=" + id +
                ", count=" + count +
                ", productId='" + productId + '\'' +
                ", spv=" + spv +
                ", labels=" + labels +
                ", lable='" + lable + '\'' +
                ", customCard=" + customCard +
                '}';
    }
}
