package com.thebeastshop.trans.exception;

/**
 * 所有未知情况都应抛出此异常。
 *
 * @author Liang Wenjian
 */
public class TsUnknownException extends TsBaseException {
    public static final String DEFAULT_MSG = "发生了未知错误，请稍后重试或联系客服。";

    private static final long serialVersionUID = 1979687692306854307L;

    //----------------------------------------------------

    public TsUnknownException() {
        super(DEFAULT_MSG);
    }

    public TsUnknownException(final String message) {
        super(message);
    }

    public TsUnknownException(final String message, final Throwable cause) {
        super(message, cause);
    }

    public TsUnknownException(final Throwable cause) {
        super(DEFAULT_MSG, cause);
    }

    //----------------------------------------------------
}
