package com.thebeastshop.trans.enums;

public enum TsOrderTypeEnum {

	ORDERTYPE_0(0,"普通"),
	ORDERTYPE_1(1,"月送鲜花"),
	ORDERTYPE_2(2,"凑钱"),
	ORDERTYPE_3(3,"买赠"),
	ORDERTYPE_4(4,"普通定制"),
	ORDERTYPE_5(5,"配方定制"),
	ORDERTYPE_6(6,"浦发"),
	//ORDERTYPE_7(7,""),
	ORDERTYPE_8(8,"圣诞集赞兑换"),
	ORDERTYPE_9(9,"积分兑换"),
	ORDERTYPE_10(10,"团购"),
	ORDERTYPE_13(13,"野兽课堂");
	 
	private int code;
	
	private String name;
	
	TsOrderTypeEnum(int code,String name){
		this.code = code;
		this.name = name;
	}

	public int getCode() {
		return code;
	}

	public void setCode(int code) {
		this.code = code;
	}

	public String getName() {
		return name;
	}
	
	public static TsOrderTypeEnum getEnumByCode(int code) {
		for (TsOrderTypeEnum e : TsOrderTypeEnum.values()) {
			if (e.getCode()==code) {
				return e;
			}
		}
		return null;
	}


	public void setName(String name) {
		this.name = name;
	}
	
	
	
}
