package com.thebeastshop.trans.enums;

public enum TsLogisticsTypeEnum {
	SHOP(1, "店送", ""),
    FEDEX(2, "联邦", "400-8891-888"),
    SF_AIR(3, "顺丰空运", "95338"),
    SF_LAND(4, "顺丰陆运", "95338"),
    YT(5, "圆通", ""),
    DEPPON(6, "德邦", ""),
    HT(7, "海淘顺丰", ""),
    SELF(8, "自送", ""),
    ZTO(9,"中通","95311"),
    AXD(10, "安鲜达", ""),
    SS(11,"闪送",""),
    SF_LL(12, "顺丰冷链", ""),
    ST(13,"申通",""),
    YD(14,"韵达",""),
	KYE(15, "跨越速运", ""),
	JD_AIR(16,"京东空运", ""),
	JD_LAND(17, "京东陆运", ""),
	JD_INSTANT(18, "京东即时达",""),
	SF_DAY(19, "顺丰即日", ""),
	POST_LAND(20, "邮政陆运", ""),
	POST_AIR(21, "邮政空运", "");


	private Integer code;
	
	private String name;
	
	private String tel;

	TsLogisticsTypeEnum(Integer code, String name, String tel) {
		this.code = code;
		this.name = name;
		this.tel = tel;
	}

	public Integer getCode() {
		return code;
	}
	
	public String getName(){
		return name;
	}
	
	public String getTel(){
		return tel;
	}

	public static TsLogisticsTypeEnum getEnumByCode(Integer code) {
		for (TsLogisticsTypeEnum e : TsLogisticsTypeEnum.values()) {
			if (e.getCode().equals(code)) {
				return e;
			}
		}
		return null;
	}
	
	@Override
	public String toString() {
		return this.getCode().toString();
	}
}
