package com.thebeastshop.stock.dto;

import com.thebeastshop.stock.vo.SStockChannelVO;

/**
 * 非组合 SPV 库存查询接口
 * <p>
 * 实现该接口的 SPV 查询类一定是非组合的普通 SPV
 * <p>
 * 非组合的 SPV 一般只有一个 SKU，一个渠道
 *
 * @author Jun.Gong [jun.gong@thebeastshop.com]
 */
public interface SNonCombinedSpvStockQuery extends SAlwaysCanUse {

    /**
     * 获取 SPV 库存渠道
     *
     * @return 库存渠道 {@link SStockChannelVO} 对象实例
     */
    SStockChannelVO getChannel();

    /**
     * 获取 SPV 下的 SKU 编号
     *
     * @return SKU 编号
     */
    String getSkuCode();

}
