package com.thebeastshop.stock.dto;

import java.util.List;

/**
 * 含有 SKU 组合项的对象接口
 *
 * @author Jun.Gong [jun.gong@thebeastshop.com]
 * @param <SELF> 对象自身
 * @since 1.7.6
 */
public interface HasCombination<SELF extends HasCombination> {

    List<SCombinationDTO> getCombinations();

    SELF setCombinations(List<SCombinationDTO> combinations);

    /**
     * 添加组合商品中的 SKU 组合项
     *
     * @param combination 组合商品 SKU 组合项 {@link SCombinationDTO} 对象
     * @return 返回自身
     */
    SELF addCombination(SCombinationDTO combination);
}
