package com.thebeastshop.stock.dto;

import com.thebeastshop.common.BaseDO;
import com.thebeastshop.stock.enums.SPresaleStatusEnum;
import com.thebeastshop.stock.enums.SStockOccupyTypeEnum;
import com.thebeastshop.stock.enums.SStockOperationTypeEnum;

import java.util.List;

/**
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2017-08-17 18:54
 */
public class SStockOperationDTO extends BaseDO {

    protected SStockOperationTypeEnum operationType;

    protected SStockOccupyTypeEnum occupyType;

    protected List<Integer> occupyTypes;

    protected List<String> warehouseCodes;

    protected Long presaleId;
    protected SPresaleStatusEnum presaleStatus;

    private Boolean presaleTransfered = false;  // 预售库存是否已转换

    protected Integer redisTotalBefore;     // 操作前的总数[redis]
    protected Integer redisCanUseBefore;     // 操作前的可用数[redis]
    protected Integer dbTotalBefore;        // 操作前的总数[db]
    protected Integer dbCanUseBefore;        // 操作前的可用数[db]


    public SStockOperationTypeEnum getOperationType() {
        if (operationType != null) return operationType;
        if (occupyType != null) return occupyType.getReleaseOperationType();
        return null;
    }

    public void setOperationType(SStockOperationTypeEnum operationType) {
        this.operationType = operationType;
    }

    public SStockOccupyTypeEnum getOccupyType() {
        return occupyType;
    }

    public void setOccupyType(SStockOccupyTypeEnum occupyType) {
        this.occupyType = occupyType;
    }

    public List<Integer> getOccupyTypes() {
        return occupyTypes;
    }

    public void setOccupyTypes(List<Integer> occupyTypes) {
        this.occupyTypes = occupyTypes;
    }

    public List<String> getWarehouseCodes() {
        return warehouseCodes;
    }

    public void setWarehouseCodes(List<String> warehouseCodes) {
        this.warehouseCodes = warehouseCodes;
    }

    public Long getPresaleId() {
        return presaleId;
    }

    public void setPresaleId(Long presaleId) {
        this.presaleId = presaleId;
    }

    public SPresaleStatusEnum getPresaleStatus() {
        return presaleStatus;
    }

    public void setPresaleStatus(SPresaleStatusEnum presaleStatus) {
        this.presaleStatus = presaleStatus;
    }

    public Boolean getPresaleTransfered() {
        return presaleTransfered;
    }

    public void setPresaleTransfered(Boolean presaleTransfered) {
        this.presaleTransfered = presaleTransfered;
    }

    public Integer getRedisTotalBefore() {
        return redisTotalBefore;
    }

    public void setRedisTotalBefore(Integer redisTotalBefore) {
        this.redisTotalBefore = redisTotalBefore;
    }

    public Integer getRedisCanUseBefore() {
        return redisCanUseBefore;
    }

    public void setRedisCanUseBefore(Integer redisCanUseBefore) {
        this.redisCanUseBefore = redisCanUseBefore;
    }

    public Integer getDbTotalBefore() {
        return dbTotalBefore;
    }

    public void setDbTotalBefore(Integer dbTotalBefore) {
        this.dbTotalBefore = dbTotalBefore;
    }

    public Integer getDbCanUseBefore() {
        return dbCanUseBefore;
    }

    public void setDbCanUseBefore(Integer dbCanUseBefore) {
        this.dbCanUseBefore = dbCanUseBefore;
    }
}
