package com.thebeastshop.stock.dto;

import java.util.LinkedList;
import java.util.List;

/**
 * 普通线上渠道下的组合商品 SPV 的库存明细查询对象
 *
 * @author Jun.Gong [jun.gong@thebeastshop.com]
 * @since 1.7.6
 */
public class SSpvCombinedStockDetailQueryDTO extends SAbstractSpvStockDetailQueryDTO<SSpvCombinedStockDetailQueryDTO> implements HasCombination<SSpvCombinedStockDetailQueryDTO>, SSpvStockDetailQuery {

    private List<SCombinationDTO> combinations = new LinkedList<>();

    public SSpvCombinedStockDetailQueryDTO() {
        this.combined = true;
    }

    @Override
    public List<SCombinationDTO> getCombinations() {
        return combinations;
    }

    @Override
    public SSpvCombinedStockDetailQueryDTO setCombinations(List<SCombinationDTO> combinations) {
        this.combinations = combinations;
        return this;
    }

    @Override
    public SSpvCombinedStockDetailQueryDTO addCombination(SCombinationDTO combination) {
        this.combinations.add(combination);
        return this;
    }
}
