package com.thebeastshop.stock.vo;

import com.thebeastshop.common.BaseDO;
import com.thebeastshop.stock.enums.SVirtualStockType;

/**
 * 释放已锁现货库存的结果VO类
 * <p>封装释放根据预售虚拟库存锁定的现货库存的结果</p>
 *
 * @author gongjun
 */
public class SReleaseSpotStockResultVO extends BaseDO {

    /**
     * 预售虚拟库存ID
     */
    private Long virtualStockId;

    /**
     * 预售ID
     */
    private Long presaleId;

    /**
     * 库存类型 (如：权益库存)
     */
    private SVirtualStockType stockType;

    /**
     * SKU编号
     */
    private String skuCode;

    /**
     * 业务编号（如：权益号）
     */
    private String businessCode;

    /**
     * 仓库号
     */
    private String warehouseCode;

    /**
     * 释放数量
     */
    private Integer quantity;

    public Long getVirtualStockId() {
        return virtualStockId;
    }

    public void setVirtualStockId(Long virtualStockId) {
        this.virtualStockId = virtualStockId;
    }

    public Long getPresaleId() {
        return presaleId;
    }

    public void setPresaleId(Long presaleId) {
        this.presaleId = presaleId;
    }

    public SVirtualStockType getStockType() {
        return stockType;
    }

    public void setStockType(SVirtualStockType stockType) {
        this.stockType = stockType;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public String getBusinessCode() {
        return businessCode;
    }

    public void setBusinessCode(String businessCode) {
        this.businessCode = businessCode;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public Integer getQuantity() {
        return quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }
}
