package com.thebeastshop.stock.enums;

public enum WhCommandStatusEnum {

    STATUS_CANCELED(0,"取消"),
    STATUS_IN_PROCESSING(1,"执行中"),
    STATUS_FINISHED(2,"完成"),
    STATUS_WAITING_QUALITY_CONTROL(3,"待质检"),
    STATUS_QUALITY_PROCESSING(4,"质检中"),
    STATUS_PICKING(5,"待拣货"),
    STATUS_DISTRIBUTION(6,"待分拨"),
    STATUS_PACKING(7,"待包装"),
    STATUS_HANDOVER(8,"待交接"),
    STATUS_DELIVERYCOMPLETION(9,"发货完成"),
    STATUS_SHORTAGES(10,"缺货中"),
    STATUS_QUALITY_FINISHED(11,"收货质检完成"),
    ;

    private Integer code;

    private String name;

    WhCommandStatusEnum(Integer code,String name){
        this.code = code;
        this.name = name;
    }

    public Integer getCode() {
        return code;
    }


    public String getName() {
        return name;
    }


    public static WhCommandStatusEnum getEnumByCode(Integer code) {
        for (WhCommandStatusEnum e : WhCommandStatusEnum.values()) {
            if (e.getCode().equals(code)) {
                return e;
            }
        }
        return null;
    }

    @Override
    public String toString() {
        return this.getCode().toString();
    }
}
