package com.thebeastshop.stock.vo;

import com.thebeastshop.common.BaseDO;
import com.thebeastshop.stock.dto.SAlwaysCanUse;

import java.util.List;
import java.util.Map;

/**
 * SPU 库存明细
 */
public class SSpuStockDetailVO extends BaseDO implements SAlwaysCanUse<SSpuStockDetailVO> {

    /**
     * SPU 编号
     */
    private String prodCode;

    /**
     * 是否组合
     */
    private Boolean combined;

    /**
     * 是否来单
     */
    private Boolean jit;

    /**
     * 是否定金预售
     */
    private Boolean deposit;

    /**
     * 是否预告
     */
    private Boolean announce;

    /**
     * SPU 库存总数
     */
    private Integer totalQuantity;

    /**
     * SPU 可用库存数
     */
    private Integer canUseQuantity;

    /**
     * 该 SPU 下的所有 SPV 库存信息映射表
     * <ul>
     *     <li>Key: SPV ID</li>
     *     <li>Value: SPV 库存 {@link SSpvStockDetailVO} 对象实例</li>
     * </ul>
     */
    private Map<Long, SSpvStockDetailVO> spvStocks;

    /**
     * 该 SPU 库存是否可用
     */
    private Boolean canUse;

    public String getProdCode() {
        return prodCode;
    }

    public void setProdCode(String prodCode) {
        this.prodCode = prodCode;
    }

    public Boolean getCombined() {
        return combined;
    }

    public void setCombined(Boolean combined) {
        this.combined = combined;
    }

    @Override
    public Boolean getJit() {
        return jit;
    }

    public SSpuStockDetailVO setJit(Boolean jit) {
        this.jit = jit;
        return this;
    }

    @Override
    public Boolean getDeposit() {
        return deposit;
    }

    public SSpuStockDetailVO setDeposit(Boolean deposit) {
        this.deposit = deposit;
        return this;
    }

    @Override
    public Boolean getAnnounce() {
        return announce;
    }

    public SSpuStockDetailVO setAnnounce(Boolean announce) {
        this.announce = announce;
        return this;
    }

    public Integer getTotalQuantity() {
        return totalQuantity;
    }

    public void setTotalQuantity(Integer totalQuantity) {
        this.totalQuantity = totalQuantity;
    }

    public Integer getCanUseQuantity() {
        return canUseQuantity;
    }

    public void setCanUseQuantity(Integer canUseQuantity) {
        this.canUseQuantity = canUseQuantity;
    }

    public Map<Long, SSpvStockDetailVO> getSpvStocks() {
        return spvStocks;
    }

    public void setSpvStocks(Map<Long, SSpvStockDetailVO> spvStocks) {
        this.spvStocks = spvStocks;
    }

    public Boolean getCanUse() {
        return canUse;
    }

    public void setCanUse(Boolean canUse) {
        this.canUse = canUse;
    }

}
