package com.thebeastshop.stock.vo;

import com.thebeastshop.common.BaseDO;

import java.util.Map;

public class SAbstractIPosStockDetail<T> extends BaseDO {

    /**
     * 商品编号
     */
    private String prodCode;

    /**
     * 本店库存
     */
    private T localStock;

    /**
     * 预售库存
     */
    private T presaleStock;

    /**
     * 配送仓库存
     * <ul>
     *     <li>Key: 渠道号</li>
     *     <li>Value: SPU 库存明细 {@link T} 对象</li>
     * </ul>
     */
    private Map<String, T> dispatchStocks;


    public String getProdCode() {
        return prodCode;
    }

    public void setProdCode(String prodCode) {
        this.prodCode = prodCode;
    }

    public T getLocalStock() {
        return localStock;
    }

    public void setLocalStock(T localStock) {
        this.localStock = localStock;
    }

    public T getPresaleStock() {
        return presaleStock;
    }

    public void setPresaleStock(T presaleStock) {
        this.presaleStock = presaleStock;
    }

    public Map<String, T> getDispatchStocks() {
        return dispatchStocks;
    }

    public void setDispatchStocks(Map<String, T> dispatchStocks) {
        this.dispatchStocks = dispatchStocks;
    }
}
