package com.thebeastshop.stock.dto;

import com.thebeastshop.stock.vo.SStockChannelVO;

import java.util.LinkedList;
import java.util.List;

/**
 * iPos 下的组合商品 SPV 库存明细查询对象
 *
 * @author Jun.Gong [jun.gong@thebeastshop.com]
 * @see com.thebeastshop.stock.dto.HasCombination
 * @see com.thebeastshop.stock.dto.SAbstractSpvStockDetailQueryDTO
 * @see com.thebeastshop.stock.dto.SIPosSpvStockDetailQuery
 * @see com.thebeastshop.stock.dto.SAbstractStockQueryDTO
 * @see com.thebeastshop.stock.dto.SAbstractSpvStockDetailQueryDTO
 * @since 1.7.6
 */
public class SIPosSpvCombinedStockDetailQueryDTO extends SAbstractSpvStockDetailQueryDTO<SIPosSpvCombinedStockDetailQueryDTO> implements HasCombination<SIPosSpvCombinedStockDetailQueryDTO>, SIPosSpvStockDetailQuery<SIPosSpvCombinedStockDetailQueryDTO> {

    /**
     * SKU 组合项
     */
    private List<SCombinationDTO> combinations = new LinkedList<>();

    /**
     * 配送仓渠道列表
     */
    private List<SStockChannelVO> dispatchChannels = new LinkedList<>();

    @Override
    public List<SCombinationDTO> getCombinations() {
        return combinations;
    }

    @Override
    public SIPosSpvCombinedStockDetailQueryDTO setCombinations(List<SCombinationDTO> combinations) {
        this.combinations = combinations;
        return this;
    }

    @Override
    public SIPosSpvCombinedStockDetailQueryDTO addCombination(SCombinationDTO combination) {
        this.combinations.add(combination);
        return this;
    }

    @Override
    public List<SStockChannelVO> getDispatchChannels() {
        return dispatchChannels;
    }

    public SIPosSpvCombinedStockDetailQueryDTO setDispatchChannels(List<SStockChannelVO> dispatchChannels) {
        this.dispatchChannels = dispatchChannels;
        return this;
    }
}
