package com.thebeastshop.stock.dto;

/**
 * 永不售罄查询接口
 *
 * @author Jun.Gong [jun.gong@thebeastshop.com]
 * @since 1.7.6
 */
public interface SAlwaysCanUse<SELF extends SAlwaysCanUse> {

    /**
     * 永不售罄默认可用库存数（库存一定可用的情况下适用的库存可用数）
     */
    Integer ALWAYS_CAN_USE_QUANTITY = 9999;

    /**
     * 是否来单
     *
     * @return {@code true}: 是来单, 否则不是来单
     */
    Boolean getJit();

    /**
     * 设置是否来单
     *
     * @param jit {@code true}: 是来单, 否则不是来单
     * @return 返回自身
     */
    SELF setJit(Boolean jit);

    /**
     * 是否预告
     *
     * @return {@code true}: 是预告, 否则不是预告
     */
    Boolean getAnnounce();

    /**
     * 设置是否预告
     *
     * @param announce {@code true}: 是预告, 否则不是预告
     * @return 返回自身
     */
    SELF setAnnounce(Boolean announce);

    /**
     * 是否定金预售
     *
     * @return {@code true}: 是定金, 否则不是定金
     */
    Boolean getDeposit();

    /**
     * 设置是否定金预售
     *
     * @return {@code true}: 是定金, 否则不是定金
     */
    SELF setDeposit(Boolean deposit);
}
