package com.thebeastshop.stock.dto;

import com.thebeastshop.common.BaseDO;
import com.thebeastshop.stock.vo.SStockChannelVO;

/**
 * 抽象库存查询对象
 *
 * @param <SELF> 对象自身
 * @since 1.7.6
 */
public abstract class SAbstractStockQueryDTO<SELF extends SAbstractStockQueryDTO<SELF>> extends BaseDO {

    /**
     * 是否组合
     */
    protected Boolean combined = false;

    /**
     * 是否来单
     */
    protected Boolean jit;

    /**
     * 是否预告
     */
    protected Boolean announce;

    /**
     * 是否定金预售
     */
    protected Boolean deposit;


    public Boolean getCombined() {
        return combined;
    }

    public Boolean getJit() {
        return jit;
    }

    public SELF setJit(Boolean jit) {
        this.jit = jit;
        return (SELF) this;
    }

    public Boolean getAnnounce() {
        return announce;
    }

    public SELF setAnnounce(Boolean announce) {
        this.announce = announce;
        return (SELF) this;
    }

    public Boolean getDeposit() {
        return deposit;
    }

    public SELF setDeposit(Boolean deposit) {
        this.deposit = deposit;
        return (SELF) this;
    }

}
