package com.thebeastshop.stock.dto;

import com.thebeastshop.stock.vo.SStockChannelVO;

import java.util.LinkedList;
import java.util.List;

/**
 * 抽象 SPU 库存明细查询基类
 *
 * @author Jun.Gong [jun.gong@thebeastshop.com]
 * @param <SELF> 对象自身
 * @see com.thebeastshop.stock.dto.SAbstractStockQueryDTO
 * @since 1.7.6
 */
public abstract class SAbstractSpuStockDetailQueryDTO<SELF extends SAbstractSpuStockDetailQueryDTO<SELF>> extends SAbstractStockQueryDTO<SELF> implements SAlwaysCanUse<SELF> {

    /**
     * 商品编号
     */
    protected String prodCode;

    /**
     * 商品渠道
     */
    protected SStockChannelVO channel;

    /**
     * SPV 查询信息列表
     */
    private List<SSpvStockDetailQuery> spvList = new LinkedList<>();


    public String getProdCode() {
        return prodCode;
    }

    public SELF setProdCode(String prodCode) {
        this.prodCode = prodCode;
        return (SELF) this;
    }

    public List<SSpvStockDetailQuery> getSpvList() {
        return spvList;
    }

    public SELF setSpvList(List<SSpvStockDetailQuery> spvList) {
        this.spvList = spvList;
        return (SELF) this;
    }

    public SELF addSpv(SSpvStockDetailQuery spvQuery) {
        if (spvList == null) {
            spvList = new LinkedList<>();
        }
        spvList.add(spvQuery);
        return (SELF) this;
    }

    public SStockChannelVO getChannel() {
        return channel;
    }

    public SELF setChannel(SStockChannelVO channel) {
        this.channel = channel;
        return (SELF) this;
    }


}
