/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.stock.vo;

import com.thebeastshop.common.BaseDO;
import com.thebeastshop.stock.constant.SStockPresaleConstants;

import org.apache.commons.lang3.time.DateFormatUtils;

import java.util.Date;

/**
 * @author gongjun
 * @since 2017-02-09
 */
public class SPresaleVO extends BaseDO {

    private static final long serialVersionUID = 1L;
    
	private Long id;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * SKU CODE
     */
    private String skuCode;
    private String skuName;
    /**
     * 预售开始日期
     */
    private Date openTime;
    /**
     * 预售结束日期
     */
    private Date closeTime;
    /**
     * 预计发货日期
     */
    private Date planedDeliveryDate;
    /**
     * 预售数量
     */
    private Integer totalQuantity;
    /**
     * 配送仓库编码
     */
    private String dispatchWarehouseCode;

    private String dispatchWarehouseName;
    /**
     * 是否需要通知，0否1是
     */
    private Integer needNotify;
    /**
     * 通知发送时间
     */
    private Date notifyTime;
    /**
     * 通知邮件
     */
    private String notifyEmail;
    /**
     * 创建人ID
     */
    private Integer createOperatorId;
    /**
     * 创建人姓名
     */
    private String createOperatorName;
    /**
     * 预售说明
     */
    private String presaleDesc;
    /**
     * 状态 0-禁用，1-启用
     */
    private Integer presaleStatus;

    /**
     * 已售数量
     */
    private Integer saledQuantity;

    /**
     * 已转换的数量
     */
    private Integer convertedQuantity;
    /**
     * 已发货数量
     */
    private Integer deliveriedQuantity;

    /**
     * 渠道, 0：线上，1：线下
     */
    private Integer channelType;
    /**
     * 是否同步三方库存 1同步 0不同步
     */
    private Integer synThirdParty;
    /**
     * 第三方商品ID
     */
    private Long thirdPartyGoodsId;
    /**
     * 第三方商品标题
     */
    private String thirdPartyGoodsTitle;
    /**
     * 第三方sku ID
     */
    private Long thirdPartySkuId;

	private Integer allotedQuantity;
  //拼团占用数量
	private Integer groupBuyOccupyQuantity;


	private Integer whetherConvergence;
	
	private Date effectiveTime;
	
	private String verifyRemind;

    public Integer getWhetherConvergence() {
		return whetherConvergence;
	}

	public void setWhetherConvergence(Integer whetherConvergence) {
		this.whetherConvergence = whetherConvergence;
	}

	public Date getEffectiveTime() {
		return effectiveTime;
	}

	public void setEffectiveTime(Date effectiveTime) {
		this.effectiveTime = effectiveTime;
	}

	public Integer getChannelType() {
		return channelType;
	}

	public void setChannelType(Integer channelType) {
		this.channelType = channelType;
	}

	public Integer getAllotedQuantity() {
		return allotedQuantity;
	}

	public void setAllotedQuantity(Integer allotedQuantity) {
		this.allotedQuantity = allotedQuantity;
	}



    public Integer getDeliveriedQuantity() {
        return deliveriedQuantity;
    }

    public void setDeliveriedQuantity(Integer deliveriedQuantity) {
        this.deliveriedQuantity = deliveriedQuantity;
    }

    public Integer getConvertedQuantity() {
        return convertedQuantity;
    }

    public void setConvertedQuantity(Integer convertedQuantity) {
        this.convertedQuantity = convertedQuantity;
    }

    public Integer getSaledQuantity() {
        return saledQuantity;
    }

    public void setSaledQuantity(Integer saledQuantity) {
        this.saledQuantity = saledQuantity;
    }

    public String getPresaleDesc() {
        return presaleDesc;
    }

    public void setPresaleDesc(String presaleDesc) {
        this.presaleDesc = presaleDesc;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getDispatchWarehouseName() {
        return dispatchWarehouseName;
    }

    public void setDispatchWarehouseName(String dispatchWarehouseName) {
        this.dispatchWarehouseName = dispatchWarehouseName;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public String getSkuName() {
        return skuName;
    }

    public void setSkuName(String skuName) {
        this.skuName = skuName;
    }

    public Date getOpenTime() {
        return openTime;
    }

    public void setOpenTime(Date openTime) {
        this.openTime = openTime;
    }

    public Date getCloseTime() {
        return closeTime;
    }

    public void setCloseTime(Date closeTime) {
        this.closeTime = closeTime;
    }

    public Date getPlanedDeliveryDate() {
        return planedDeliveryDate;
    }

    public void setPlanedDeliveryDate(Date planedDeliveryDate) {
        this.planedDeliveryDate = planedDeliveryDate;
    }

    public Integer getTotalQuantity() {
        return totalQuantity;
    }

    public void setTotalQuantity(Integer totalQuantity) {
        this.totalQuantity = totalQuantity;
    }

    public String getDispatchWarehouseCode() {
        return dispatchWarehouseCode;
    }

    public void setDispatchWarehouseCode(String dispatchWarehouseCode) {
        this.dispatchWarehouseCode = dispatchWarehouseCode;
    }

    public Integer getNeedNotify() {
        return needNotify;
    }

    public void setNeedNotify(Integer needNotify) {
        this.needNotify = needNotify;
    }

    public Date getNotifyTime() {
        return notifyTime;
    }

    public void setNotifyTime(Date notifyTime) {
        this.notifyTime = notifyTime;
    }

    public String getNotifyEmail() {
        return notifyEmail;
    }

    public void setNotifyEmail(String notifyEmail) {
        this.notifyEmail = notifyEmail;
    }

    public Integer getCreateOperatorId() {
        return createOperatorId;
    }

    public void setCreateOperatorId(Integer createOperatorId) {
        this.createOperatorId = createOperatorId;
    }

    public String getCreateOperatorName() {
        return createOperatorName;
    }

    public Integer getPresaleStatus() {
        return presaleStatus;
    }

    public void setPresaleStatus(Integer presaleStatus) {
        this.presaleStatus = presaleStatus;
    }

    public void setCreateOperatorName(String createOperatorName) {
        this.createOperatorName = createOperatorName;
    }

    public String getOpenTimeStr(){
        if (openTime == null) {
            return "";
        }
        return DateFormatUtils.format(openTime, SStockPresaleConstants.DEFAULT_DATETIME_FORMAT);
    }
    public String getCloseTimeStr(){
        if (closeTime == null) {
            return "";
        }
        return DateFormatUtils.format(closeTime, SStockPresaleConstants.DEFAULT_DATETIME_FORMAT);
    }
    public String getPlanedDeliveryDateStr(){
        if (planedDeliveryDate == null) {
            return "";
        }
        return DateFormatUtils.format(planedDeliveryDate, SStockPresaleConstants.DEFAULT_DATETIME_FORMAT);
    }

    public boolean getCanEdit(){

        return (new Date()).compareTo(closeTime) < 0;

    }

    public boolean getCanEditOpenTime(){
        return (new Date()).compareTo(openTime) < 0;

    }
    /**
     * 状态 0-禁用，1-启用
     */
    
    public String getPresaleStatusStr(){
    	if(presaleStatus == null){
    		return "";
    	}
    	if(presaleStatus == 0){
    		return "禁用";
    	}else if(presaleStatus == 1){
    		return "启用";
    	}
    	return "ErrorStatus";
    }
    
    /**
     * 是否需要通知，0否1是
     */
  
    public String getNeedNotifyStr(){
    	if(needNotify == null){
    		return "";
    	}
    	if(needNotify == 0){
    		return "N";
    	}else if(needNotify == 1){
    		return "Y";
    	}
    	
    	return "ErrorStatus";
    }
    
    public String getNeedNotifyName(){
    	if(needNotify == null){
    		return "";
    	}
    	if(needNotify == 0){
    		return "否";
    	}else if(needNotify == 1){
    		return "是";
    	}
    	
    	return "错误";
    }
    
    public String getPresaleStatusName(){
    	if(presaleStatus == null){
    		return "";
    	}
    	if(presaleStatus == 0){
    		return "否";
    	}else if(presaleStatus == 1){
    		return "是";
    	}
    	return "错误";
    }
    
    public String getChannelTypeStr(){
    	if(channelType == null){
    		return null;
    	}
    	if(channelType == SStockPresaleConstants.CHANNEL_TYPE_BEAST){
    		return "官网";
    	}else if(channelType == SStockPresaleConstants.CHANNEL_TYPE_THIRDPARTY){
    		return "第三方";
    	}else if(channelType == SStockPresaleConstants.CHANNEL_TYPE_TMALL){
    		return "天猫";
    	}else if(channelType == SStockPresaleConstants.CHANNEL_TYPE_JD){
    		return "京东";
    	}else if(channelType == SStockPresaleConstants.CHANNEL_TYPE_TMALL_JIAFANG){
    		return "天猫家纺";
    	}
        else if(channelType == SStockPresaleConstants.CHANNEL_TYPE_TMALL_HOME){
            return "天猫Home";
        }
        else if(channelType == SStockPresaleConstants.CHANNEL_TYPE_JD_HOME){
            return "京东Home";
        }
        else if(channelType == SStockPresaleConstants.CHANNEL_TYPE_TMALL_NAKED){
            return "天猫Naked";
        }
        else if(channelType == SStockPresaleConstants.CHANNEL_TYPE_TMALL_LITTLEB){
            return "天猫LittleB";
        }
    	return "ErrorStatus";
    }
    
    
    public static Integer translateChannelType(String channelStr){
    	if("官网".equals(channelStr)){
    		return SStockPresaleConstants.CHANNEL_TYPE_BEAST;
    	}else if("天猫".equals(channelStr)){
    		return SStockPresaleConstants.CHANNEL_TYPE_TMALL;
    	}else if("京东".equals(channelStr)){
    		return SStockPresaleConstants.CHANNEL_TYPE_JD;
    	}else if("天猫家纺".equals(channelStr)){
    		return SStockPresaleConstants.CHANNEL_TYPE_TMALL_JIAFANG;
    	}else if("第三方".equals(channelStr)){
    		return SStockPresaleConstants.CHANNEL_TYPE_THIRDPARTY;
    	}
        else if("天猫Home".equals(channelStr)){
            return SStockPresaleConstants.CHANNEL_TYPE_TMALL_HOME;
        }
        else if("京东Home".equals(channelStr)){
            return SStockPresaleConstants.CHANNEL_TYPE_JD_HOME;
        }else if("天猫Naked".equals(channelStr)){
            return SStockPresaleConstants.CHANNEL_TYPE_TMALL_NAKED;
        }else if("天猫LittleB".equals(channelStr)){
            return SStockPresaleConstants.CHANNEL_TYPE_TMALL_LITTLEB;
        }
    	return SStockPresaleConstants.CHANNEL_TYPE_BEAST;
    }

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = super.hashCode();
		result = prime * result + ((id == null) ? 0 : id.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (!super.equals(obj))
			return false;
		if (getClass() != obj.getClass())
			return false;
		SPresaleVO other = (SPresaleVO) obj;
		if (id == null) {
			if (other.id != null)
				return false;
		} else if (!id.equals(other.id))
			return false;
		return true;
	}

	public String getVerifyRemind() {
		return verifyRemind;
	}

	public void setVerifyRemind(String verifyRemind) {
		this.verifyRemind = verifyRemind;
	}

  public Integer getGroupBuyOccupyQuantity() {
    return groupBuyOccupyQuantity;
  }

  public void setGroupBuyOccupyQuantity(Integer groupBuyOccupyQuantity) {
    this.groupBuyOccupyQuantity = groupBuyOccupyQuantity;
  }

    public Integer getSynThirdParty() {
        return synThirdParty;
    }

    public void setSynThirdParty(Integer synThirdParty) {
        this.synThirdParty = synThirdParty;
    }

    public Long getThirdPartyGoodsId() {
        return thirdPartyGoodsId;
    }

    public void setThirdPartyGoodsId(Long thirdPartyGoodsId) {
        this.thirdPartyGoodsId = thirdPartyGoodsId;
    }

    public String getThirdPartyGoodsTitle() {
        return thirdPartyGoodsTitle;
    }

    public void setThirdPartyGoodsTitle(String thirdPartyGoodsTitle) {
        this.thirdPartyGoodsTitle = thirdPartyGoodsTitle;
    }

    public Long getThirdPartySkuId() {
        return thirdPartySkuId;
    }

    public void setThirdPartySkuId(Long thirdPartySkuId) {
        this.thirdPartySkuId = thirdPartySkuId;
    }
}
