package com.thebeastshop.stock.dto;

import com.thebeastshop.common.BaseDO;
import com.thebeastshop.stock.enums.SVirtualStockType;

/**
 * 预售虚拟库存释放DTO类
 * @author gongjun
 */
public class SPresaleVirtualStockReleaseDTO extends BaseDO {

    /**
     * 预售ID
     */
    private Long presaleId;

    /**
     * 库存类型（如：权益）
     */
    private SVirtualStockType stockType;

    /**
     * 业务编号（如：权益编号）
     */
    private String businessCode;

    /**
     * SKU编号
     */
    private String skuCode;

    /**
     * 要释放到的数量
     */
    private Integer toQuantity;

    /**
     * 描述
     */
    private String description;


    public Long getPresaleId() {
        return presaleId;
    }

    public void setPresaleId(Long presaleId) {
        this.presaleId = presaleId;
    }

    public SVirtualStockType getStockType() {
        return stockType;
    }

    public void setStockType(SVirtualStockType stockType) {
        this.stockType = stockType;
    }

    public String getBusinessCode() {
        return businessCode;
    }

    public void setBusinessCode(String businessCode) {
        this.businessCode = businessCode;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public Integer getToQuantity() {
        return toQuantity;
    }

    public void setToQuantity(Integer toQuantity) {
        this.toQuantity = toQuantity;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}
