/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.stock.vo;

import com.thebeastshop.common.BaseDO;
import com.thebeastshop.stock.constant.SStockPresaleConstants;
import java.util.Date;
import org.apache.commons.lang3.time.DateFormatUtils;

public class SPresaleVO
extends BaseDO {
    private static final long serialVersionUID = 1L;
    private Long id;
    private Date createTime;
    private String skuCode;
    private String skuName;
    private Date openTime;
    private Date closeTime;
    private Date planedDeliveryDate;
    private Integer totalQuantity;
    private String dispatchWarehouseCode;
    private String dispatchWarehouseName;
    private Integer needNotify;
    private Date notifyTime;
    private String notifyEmail;
    private Integer createOperatorId;
    private String createOperatorName;
    private String presaleDesc;
    private Integer presaleStatus;
    private Integer saledQuantity;
    private Integer convertedQuantity;
    private Integer deliveriedQuantity;
    private Integer channelType;
    private Integer synThirdParty;
    private Long thirdPartyGoodsId;
    private String thirdPartyGoodsTitle;
    private Long thirdPartySkuId;
    private Integer allotedQuantity;
    private Integer groupBuyOccupyQuantity;
    private Integer whetherConvergence;
    private Date effectiveTime;
    private String verifyRemind;

    public Integer getWhetherConvergence() {
        return this.whetherConvergence;
    }

    public void setWhetherConvergence(Integer whetherConvergence) {
        this.whetherConvergence = whetherConvergence;
    }

    public Date getEffectiveTime() {
        return this.effectiveTime;
    }

    public void setEffectiveTime(Date effectiveTime) {
        this.effectiveTime = effectiveTime;
    }

    public Integer getChannelType() {
        return this.channelType;
    }

    public void setChannelType(Integer channelType) {
        this.channelType = channelType;
    }

    public Integer getAllotedQuantity() {
        return this.allotedQuantity;
    }

    public void setAllotedQuantity(Integer allotedQuantity) {
        this.allotedQuantity = allotedQuantity;
    }

    public Integer getDeliveriedQuantity() {
        return this.deliveriedQuantity;
    }

    public void setDeliveriedQuantity(Integer deliveriedQuantity) {
        this.deliveriedQuantity = deliveriedQuantity;
    }

    public Integer getConvertedQuantity() {
        return this.convertedQuantity;
    }

    public void setConvertedQuantity(Integer convertedQuantity) {
        this.convertedQuantity = convertedQuantity;
    }

    public Integer getSaledQuantity() {
        return this.saledQuantity;
    }

    public void setSaledQuantity(Integer saledQuantity) {
        this.saledQuantity = saledQuantity;
    }

    public String getPresaleDesc() {
        return this.presaleDesc;
    }

    public void setPresaleDesc(String presaleDesc) {
        this.presaleDesc = presaleDesc;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getDispatchWarehouseName() {
        return this.dispatchWarehouseName;
    }

    public void setDispatchWarehouseName(String dispatchWarehouseName) {
        this.dispatchWarehouseName = dispatchWarehouseName;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getSkuCode() {
        return this.skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public String getSkuName() {
        return this.skuName;
    }

    public void setSkuName(String skuName) {
        this.skuName = skuName;
    }

    public Date getOpenTime() {
        return this.openTime;
    }

    public void setOpenTime(Date openTime) {
        this.openTime = openTime;
    }

    public Date getCloseTime() {
        return this.closeTime;
    }

    public void setCloseTime(Date closeTime) {
        this.closeTime = closeTime;
    }

    public Date getPlanedDeliveryDate() {
        return this.planedDeliveryDate;
    }

    public void setPlanedDeliveryDate(Date planedDeliveryDate) {
        this.planedDeliveryDate = planedDeliveryDate;
    }

    public Integer getTotalQuantity() {
        return this.totalQuantity;
    }

    public void setTotalQuantity(Integer totalQuantity) {
        this.totalQuantity = totalQuantity;
    }

    public String getDispatchWarehouseCode() {
        return this.dispatchWarehouseCode;
    }

    public void setDispatchWarehouseCode(String dispatchWarehouseCode) {
        this.dispatchWarehouseCode = dispatchWarehouseCode;
    }

    public Integer getNeedNotify() {
        return this.needNotify;
    }

    public void setNeedNotify(Integer needNotify) {
        this.needNotify = needNotify;
    }

    public Date getNotifyTime() {
        return this.notifyTime;
    }

    public void setNotifyTime(Date notifyTime) {
        this.notifyTime = notifyTime;
    }

    public String getNotifyEmail() {
        return this.notifyEmail;
    }

    public void setNotifyEmail(String notifyEmail) {
        this.notifyEmail = notifyEmail;
    }

    public Integer getCreateOperatorId() {
        return this.createOperatorId;
    }

    public void setCreateOperatorId(Integer createOperatorId) {
        this.createOperatorId = createOperatorId;
    }

    public String getCreateOperatorName() {
        return this.createOperatorName;
    }

    public Integer getPresaleStatus() {
        return this.presaleStatus;
    }

    public void setPresaleStatus(Integer presaleStatus) {
        this.presaleStatus = presaleStatus;
    }

    public void setCreateOperatorName(String createOperatorName) {
        this.createOperatorName = createOperatorName;
    }

    public String getOpenTimeStr() {
        if (this.openTime == null) {
            return "";
        }
        return DateFormatUtils.format((Date)this.openTime, (String)"yyyy-MM-dd HH:mm:ss");
    }

    public String getCloseTimeStr() {
        if (this.closeTime == null) {
            return "";
        }
        return DateFormatUtils.format((Date)this.closeTime, (String)"yyyy-MM-dd HH:mm:ss");
    }

    public String getPlanedDeliveryDateStr() {
        if (this.planedDeliveryDate == null) {
            return "";
        }
        return DateFormatUtils.format((Date)this.planedDeliveryDate, (String)"yyyy-MM-dd HH:mm:ss");
    }

    public boolean getCanEdit() {
        return new Date().compareTo(this.closeTime) < 0;
    }

    public boolean getCanEditOpenTime() {
        return new Date().compareTo(this.openTime) < 0;
    }

    public String getPresaleStatusStr() {
        if (this.presaleStatus == null) {
            return "";
        }
        if (this.presaleStatus == 0) {
            return "\u7981\u7528";
        }
        if (this.presaleStatus == 1) {
            return "\u542f\u7528";
        }
        return "ErrorStatus";
    }

    public String getNeedNotifyStr() {
        if (this.needNotify == null) {
            return "";
        }
        if (this.needNotify == 0) {
            return "N";
        }
        if (this.needNotify == 1) {
            return "Y";
        }
        return "ErrorStatus";
    }

    public String getNeedNotifyName() {
        if (this.needNotify == null) {
            return "";
        }
        if (this.needNotify == 0) {
            return "\u5426";
        }
        if (this.needNotify == 1) {
            return "\u662f";
        }
        return "\u9519\u8bef";
    }

    public String getPresaleStatusName() {
        if (this.presaleStatus == null) {
            return "";
        }
        if (this.presaleStatus == 0) {
            return "\u5426";
        }
        if (this.presaleStatus == 1) {
            return "\u662f";
        }
        return "\u9519\u8bef";
    }

    public String getChannelTypeStr() {
        if (this.channelType == null) {
            return null;
        }
        if (this.channelType == SStockPresaleConstants.CHANNEL_TYPE_BEAST) {
            return "\u5b98\u7f51";
        }
        if (this.channelType == SStockPresaleConstants.CHANNEL_TYPE_THIRDPARTY) {
            return "\u7b2c\u4e09\u65b9";
        }
        if (this.channelType == SStockPresaleConstants.CHANNEL_TYPE_TMALL) {
            return "\u5929\u732b";
        }
        if (this.channelType == SStockPresaleConstants.CHANNEL_TYPE_JD) {
            return "\u4eac\u4e1c";
        }
        if (this.channelType == SStockPresaleConstants.CHANNEL_TYPE_TMALL_JIAFANG) {
            return "\u5929\u732b\u5bb6\u7eba";
        }
        if (this.channelType == SStockPresaleConstants.CHANNEL_TYPE_TMALL_HOME) {
            return "\u5929\u732bHome";
        }
        if (this.channelType == SStockPresaleConstants.CHANNEL_TYPE_JD_HOME) {
            return "\u4eac\u4e1cHome";
        }
        if (this.channelType == SStockPresaleConstants.CHANNEL_TYPE_TMALL_NAKED) {
            return "\u5929\u732bNaked";
        }
        if (this.channelType == SStockPresaleConstants.CHANNEL_TYPE_TMALL_LITTLEB) {
            return "\u5929\u732bLittleB";
        }
        return "ErrorStatus";
    }

    public static Integer translateChannelType(String channelStr) {
        if ("\u5b98\u7f51".equals(channelStr)) {
            return SStockPresaleConstants.CHANNEL_TYPE_BEAST;
        }
        if ("\u5929\u732b".equals(channelStr)) {
            return SStockPresaleConstants.CHANNEL_TYPE_TMALL;
        }
        if ("\u4eac\u4e1c".equals(channelStr)) {
            return SStockPresaleConstants.CHANNEL_TYPE_JD;
        }
        if ("\u5929\u732b\u5bb6\u7eba".equals(channelStr)) {
            return SStockPresaleConstants.CHANNEL_TYPE_TMALL_JIAFANG;
        }
        if ("\u7b2c\u4e09\u65b9".equals(channelStr)) {
            return SStockPresaleConstants.CHANNEL_TYPE_THIRDPARTY;
        }
        if ("\u5929\u732bHome".equals(channelStr)) {
            return SStockPresaleConstants.CHANNEL_TYPE_TMALL_HOME;
        }
        if ("\u4eac\u4e1cHome".equals(channelStr)) {
            return SStockPresaleConstants.CHANNEL_TYPE_JD_HOME;
        }
        if ("\u5929\u732bNaked".equals(channelStr)) {
            return SStockPresaleConstants.CHANNEL_TYPE_TMALL_NAKED;
        }
        if ("\u5929\u732bLittleB".equals(channelStr)) {
            return SStockPresaleConstants.CHANNEL_TYPE_TMALL_LITTLEB;
        }
        return SStockPresaleConstants.CHANNEL_TYPE_BEAST;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        SPresaleVO other = (SPresaleVO)((Object)obj);
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String getVerifyRemind() {
        return this.verifyRemind;
    }

    public void setVerifyRemind(String verifyRemind) {
        this.verifyRemind = verifyRemind;
    }

    public Integer getGroupBuyOccupyQuantity() {
        return this.groupBuyOccupyQuantity;
    }

    public void setGroupBuyOccupyQuantity(Integer groupBuyOccupyQuantity) {
        this.groupBuyOccupyQuantity = groupBuyOccupyQuantity;
    }

    public Integer getSynThirdParty() {
        return this.synThirdParty;
    }

    public void setSynThirdParty(Integer synThirdParty) {
        this.synThirdParty = synThirdParty;
    }

    public Long getThirdPartyGoodsId() {
        return this.thirdPartyGoodsId;
    }

    public void setThirdPartyGoodsId(Long thirdPartyGoodsId) {
        this.thirdPartyGoodsId = thirdPartyGoodsId;
    }

    public String getThirdPartyGoodsTitle() {
        return this.thirdPartyGoodsTitle;
    }

    public void setThirdPartyGoodsTitle(String thirdPartyGoodsTitle) {
        this.thirdPartyGoodsTitle = thirdPartyGoodsTitle;
    }

    public Long getThirdPartySkuId() {
        return this.thirdPartySkuId;
    }

    public void setThirdPartySkuId(Long thirdPartySkuId) {
        this.thirdPartySkuId = thirdPartySkuId;
    }
}

